/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.IResponse;
import org.eclipse.webdav.internal.kernel.DocumentMarshaler;
import org.eclipse.webdav.internal.kernel.Message;
import org.eclipse.webdav.internal.kernel.Policy;
import org.eclipse.webdav.internal.kernel.Status;
import org.eclipse.webdav.internal.kernel.utils.Assert;
import org.w3c.dom.Document;

public class Response
extends Message
implements IResponse {
    protected Status status;

    public Response(Status status, IContext context, InputStream body) {
        this.status = status;
        this.context = context;
        this.body = body;
    }

    public Response(Status status, IContext context, Document body) {
        this.status = status;
        this.context = context;
        this.body = body;
    }

    @Override
    public void close() throws IOException {
        if (!this.hasDocumentBody()) {
            this.getInputStream().close();
        }
    }

    @Override
    public Document getDocumentBody() throws IOException {
        Assert.isTrue(this.hasDocumentBody(), Policy.bind("error.receiverMissingBody"));
        return (Document)this.body;
    }

    @Override
    public InputStream getInputStream() {
        Assert.isTrue(!this.hasDocumentBody(), Policy.bind("error.receiverHasBody"));
        return (InputStream)this.body;
    }

    @Override
    public int getStatusCode() {
        return this.status.getCode();
    }

    @Override
    public String getStatusMessage() {
        return this.status.getMessage();
    }

    @Override
    public boolean hasDocumentBody() {
        return this.body instanceof Document;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.status.toHTTPString());
        buffer.append('\n');
        buffer.append(this.context.toString());
        buffer.append('\n');
        try {
            if (this.hasDocumentBody()) {
                DocumentMarshaler marshaler = new DocumentMarshaler();
                StringWriter writer = new StringWriter();
                marshaler.print(this.getDocumentBody(), writer, "UTF-8");
                buffer.append(((Object)writer).toString());
            } else {
                buffer.append("<<" + Policy.bind("label.bytes", String.valueOf(this.getInputStream().available())) + ">>");
            }
        }
        catch (IOException e) {
            buffer.append("<<" + Policy.bind("exception.dumping", e.getMessage()) + ">>");
        }
        return buffer.toString();
    }
}

