/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.launching;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Map;
import org.drools.eclipse.debug.core.DroolsDebugModel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.SocketAttachConnector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.util.NLS;

public class DroolsVMConnector
extends SocketAttachConnector {
    public static final String CONNECTOR_ID = "org.drools.eclipse.launching.droolsVMConnector";

    public String getIdentifier() {
        return CONNECTOR_ID;
    }

    public void connect(Map<String, String> arguments, IProgressMonitor monitor, ILaunch launch) throws CoreException {
        String host;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.SocketAttachConnector_Connecting____1, 2);
        subMonitor.subTask(LaunchingMessages.SocketAttachConnector_Configuring_connection____1);
        AttachingConnector connector = DroolsVMConnector.getAttachingConnector();
        String portNumberString = arguments.get("port");
        if (portNumberString == null) {
            DroolsVMConnector.abort((String)LaunchingMessages.SocketAttachConnector_Port_unspecified_for_remote_connection__2, null, (int)111);
        }
        if ((host = arguments.get("hostname")) == null) {
            DroolsVMConnector.abort((String)LaunchingMessages.SocketAttachConnector_Hostname_unspecified_for_remote_connection__4, null, (int)109);
        }
        Map<String, Connector.Argument> map = connector.defaultArguments();
        Connector.Argument param = map.get("hostname");
        param.setValue(host);
        param = map.get("port");
        param.setValue(portNumberString);
        String timeoutString = arguments.get("timeout");
        if (timeoutString != null) {
            param = map.get("timeout");
            param.setValue(timeoutString);
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        boolean allowTerminate = false;
        if (configuration != null) {
            allowTerminate = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.SocketAttachConnector_Establishing_connection____2);
        try {
            VirtualMachine vm = connector.attach(map);
            String vmLabel = this.constructVMLabel(vm, host, portNumberString, configuration);
            IDebugTarget debugTarget = DroolsDebugModel.newDebugTarget(launch, vm, vmLabel, null, allowTerminate, true);
            launch.addDebugTarget(debugTarget);
            subMonitor.worked(1);
            subMonitor.done();
        }
        catch (TimeoutException e) {
            DroolsVMConnector.abort((String)LaunchingMessages.SocketAttachConnector_0, (Throwable)e, (int)113);
        }
        catch (UnknownHostException e) {
            DroolsVMConnector.abort((String)NLS.bind((String)LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_because_of_unknown_host____0___1, (Object[])new String[]{host}), (Throwable)e, (int)113);
        }
        catch (ConnectException e) {
            DroolsVMConnector.abort((String)LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_as_connection_was_refused_2, (Throwable)e, (int)113);
        }
        catch (IOException e) {
            DroolsVMConnector.abort((String)LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_1, (Throwable)e, (int)113);
        }
        catch (IllegalConnectorArgumentsException e) {
            DroolsVMConnector.abort((String)LaunchingMessages.SocketAttachConnector_Failed_to_connect_to_remote_VM_1, (Throwable)e, (int)113);
        }
    }
}

