/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.http.client;

import java.util.Vector;
import org.eclipse.webdav.internal.kernel.utils.Assert;

public class BufferPool {
    private static int BUFFER_SIZE = 8192;
    private static int MAX_BUFFERS = 5;
    private Vector pool = new Vector(MAX_BUFFERS);

    public synchronized byte[] getBuffer() {
        if (this.pool.isEmpty()) {
            return new byte[BUFFER_SIZE];
        }
        byte[] buffer = (byte[])this.pool.lastElement();
        this.pool.removeElementAt(this.pool.size() - 1);
        return buffer;
    }

    public synchronized void putBuffer(byte[] buffer) {
        Assert.isNotNull(buffer);
        Assert.isTrue(buffer.length == BUFFER_SIZE);
        if (this.pool.size() < MAX_BUFFERS) {
            this.pool.addElement(buffer);
        }
    }
}

