/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.wizard.project;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;

public class IUTreeViewer
extends CheckboxTreeViewer {
    private List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();

    public IUTreeViewer(Composite parent, int style) {
        super(parent, style);
        Tree tree = this.getTree();
        GridData gd = new GridData(1808);
        gd.minimumHeight = 3 * tree.getItemHeight();
        tree.setLayoutData((Object)gd);
    }

    public void initialize() {
        this.setContentProvider((IContentProvider)new IUTreeContentProvider());
        this.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof IUTreeItem) {
                    return ((IUTreeItem)element).isChecked();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                if (element instanceof IUTreeItem) {
                    return ((IUTreeItem)element).isGrayed();
                }
                return false;
            }
        });
        this.setLabelProvider((IBaseLabelProvider)new IUTreeLabelProvider());
        final Tree tree = this.getTree();
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (tree.getSelectionCount() == 1) {
                    IUTreeItem item = (IUTreeItem)tree.getSelection()[0].getData();
                    e.data = item.iu;
                    for (SelectionListener l : IUTreeViewer.this.selectionListeners) {
                        l.widgetSelected(e);
                    }
                }
            }
        });
        this.addCheckStateListener(new IUTreeCheckStateListener(this));
    }

    public List<IInstallableUnit> getSelectedIUs() {
        ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>();
        Object[] objectArray = this.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUTreeItem item;
            Object o = objectArray[n2];
            if (o instanceof IUTreeItem && (item = (IUTreeItem)o).parent != null) {
                result.add(item.iu);
            }
            ++n2;
        }
        return result;
    }

    public Object[] getElements() {
        return ((IUTreeContentProvider)this.getContentProvider()).getElements(null);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.selectionListeners.contains(listener)) {
            this.selectionListeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.selectionListeners.contains(listener)) {
            this.selectionListeners.remove(listener);
        }
    }

    public void dispose() {
        if (this.getTree() != null && !this.getTree().isDisposed()) {
            this.getTree().dispose();
        }
    }

    class IUTreeCheckStateListener
    implements ICheckStateListener {
        private IUTreeViewer treeViewer;

        public IUTreeCheckStateListener(IUTreeViewer treeViewer) {
            this.treeViewer = treeViewer;
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean checked = event.getChecked();
            Object element = event.getElement();
            if (element instanceof IUTreeItem) {
                IUTreeItem item = (IUTreeItem)element;
                this.updateDescendents(item, checked);
                this.updateAncestors(item.getParent(), checked);
                if (item.parent != null) {
                    item = item.parent;
                }
                Object[] objectArray = this.treeViewer.getElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object e = objectArray[n2];
                    if (e instanceof IUTreeItem && e != item) {
                        this.updateDescendents((IUTreeItem)e, false);
                    }
                    ++n2;
                }
            }
        }

        void updateDescendents(IUTreeItem item, boolean checked) {
            for (IUTreeItem child : item.getChildren()) {
                this.updateDescendents(child, checked);
            }
            item.setSubtreeChecked(checked);
            this.treeViewer.setSubtreeChecked(item, checked);
            this.treeViewer.setChecked(item, checked);
            this.treeViewer.setGrayed(item, false);
        }

        void updateAncestors(IUTreeItem item, boolean checked) {
            while (item != null) {
                int checkedCount = item.getSubtreeCheckedCount();
                int size = item.getChildren().size();
                if (checkedCount == 0) {
                    this.treeViewer.setChecked(item, false);
                    item.setChecked(false);
                    checked = true;
                } else if (checkedCount == size) {
                    this.treeViewer.setChecked(item, true);
                    this.treeViewer.setGrayed(item, false);
                    item.setChecked(true);
                } else {
                    this.treeViewer.setGrayChecked(item, true);
                    item.setChecked(true);
                }
                item = item.getParent();
            }
        }
    }

    class IUTreeContentProvider
    implements ITreeContentProvider {
        Collection<IUTreeItem> elements = new ArrayList<IUTreeItem>();
        Collection<IInstallableUnit> installableUnits = new ArrayList<IInstallableUnit>();

        IUTreeContentProvider() {
        }

        public void dispose() {
        }

        public Collection<IInstallableUnit> getInstallableUnits() {
            return this.installableUnits;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.elements.clear();
            this.installableUnits.clear();
            if (newInput instanceof IQueryResult) {
                for (Object o : (IQueryResult)newInput) {
                    if (!(o instanceof IInstallableUnit)) continue;
                    IInstallableUnit iu = (IInstallableUnit)o;
                    this.installableUnits.add(iu);
                    if (!this.isGroup(iu)) continue;
                    this.elements.add(new IUTreeItem(this, null, iu));
                }
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.elements.toArray(new Object[this.elements.size()]);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IUTreeItem) {
                Collection<IUTreeItem> children = ((IUTreeItem)parentElement).getChildren();
                return children.toArray(new Object[children.size()]);
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IUTreeItem) {
                return ((IUTreeItem)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IUTreeItem) {
                return this.isGroup(((IUTreeItem)element).iu);
            }
            return false;
        }

        public boolean isGroup(IInstallableUnit iu) {
            String isGroup = iu == null ? null : iu.getProperty("org.eclipse.equinox.p2.type.group");
            return Boolean.valueOf(isGroup);
        }
    }

    class IUTreeItem {
        private final IInstallableUnit iu;
        private final IUTreeItem parent;
        private final IUTreeContentProvider provider;
        private Collection<IUTreeItem> children;
        private boolean checked;

        public IUTreeItem(IUTreeContentProvider provider, IUTreeItem parent, IInstallableUnit iu) {
            this.provider = provider;
            this.parent = parent;
            this.iu = iu;
            this.checked = false;
        }

        public boolean isChecked() {
            if (this.parent == null) {
                for (IUTreeItem child : this.getChildren()) {
                    if (!child.isChecked()) continue;
                    return true;
                }
                return false;
            }
            return this.checked;
        }

        public boolean isGrayed() {
            if (this.parent == null) {
                int countChecked = 0;
                for (IUTreeItem child : this.getChildren()) {
                    if (!child.isChecked()) continue;
                    ++countChecked;
                }
                return countChecked > 0 && countChecked != this.children.size();
            }
            return false;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        public IUTreeItem getParent() {
            return this.parent;
        }

        public Collection<IUTreeItem> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<IUTreeItem>();
                if (this.parent == null) {
                    for (IRequirement r : this.iu.getRequirements()) {
                        for (IInstallableUnit riu : this.provider.getInstallableUnits()) {
                            if (!r.isMatch(riu)) continue;
                            IMatchExpression me = r.getFilter();
                            if (me != null) {
                                if (!me.isMatch((Object)riu)) continue;
                                this.children.add(new IUTreeItem(this.provider, this, riu));
                                continue;
                            }
                            this.children.add(new IUTreeItem(this.provider, this, riu));
                        }
                    }
                }
            }
            return this.children;
        }

        public String getName() {
            if (this.parent == null) {
                return this.iu.getProperty("org.eclipse.equinox.p2.name");
            }
            return String.valueOf(this.iu.getProperty("org.eclipse.equinox.p2.name")) + "  (v" + this.iu.getVersion() + ")";
        }

        public void setSubtreeChecked(boolean checked) {
            this.checked = checked;
            if (this.parent == null) {
                for (IUTreeItem child : this.getChildren()) {
                    child.checked = checked;
                }
            }
        }

        public int getSubtreeCheckedCount() {
            if (this.parent == null) {
                int count = 0;
                for (IUTreeItem child : this.getChildren()) {
                    count += child.checked ? 1 : 0;
                }
                return count;
            }
            return this.checked ? 1 : 0;
        }
    }

    class IUTreeLabelProvider
    implements ILabelProvider {
        IUTreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IUTreeItem) {
                return ((IUTreeItem)element).getName();
            }
            return element.toString();
        }
    }
}

