/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.wizard.project;

import java.util.Collection;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.kie.eclipse.Activator;
import org.kie.eclipse.runtime.IRuntime;
import org.kie.eclipse.runtime.IRuntimeManager;
import org.kie.eclipse.wizard.project.IKieEmptyProjectWizardPage;
import org.kie.eclipse.wizard.project.IKieOnlineExampleProjectWizardPage;
import org.kie.eclipse.wizard.project.IKieProjectStartWizardPage;
import org.kie.eclipse.wizard.project.IKieProjectWizardPage;
import org.kie.eclipse.wizard.project.IKieSampleFilesProjectWizardPage;

public class AbstractKieProjectStartWizardPage
extends WizardPage
implements IKieProjectStartWizardPage {
    private int initialProjectContent = 0;
    private IProgressMonitor progressMonitor;

    public AbstractKieProjectStartWizardPage(String pageName) {
        super(pageName);
        this.setDescription("Select the initial Project contents");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        final Button emptyProjectButton = new Button(composite, 24);
        emptyProjectButton.setImage(Activator.getImage("icons/wizards/empty-project-pushed.png"));
        gd = new GridData(2);
        gd.horizontalIndent = 10;
        gd.verticalIndent = 20;
        emptyProjectButton.setLayoutData((Object)gd);
        Label emptyProjectDescription = new Label(composite, 64);
        emptyProjectDescription.setText("Create an empty project. The project classpath will be configured with the selected Runtime and optional Maven and KJar artifacts. This option may be used for creating both Rule/Process and Work Item Definition Projects.");
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.verticalIndent = 20;
        gd.horizontalIndent = 20;
        gd.widthHint = 100;
        gd.heightHint = 80;
        emptyProjectDescription.setLayoutData((Object)gd);
        final Button sampleFilesProjectButton = new Button(composite, 24);
        sampleFilesProjectButton.setImage(Activator.getImage("icons/wizards/sample-files-project.png"));
        gd = new GridData(1);
        gd.horizontalIndent = 10;
        gd.verticalIndent = 20;
        sampleFilesProjectButton.setLayoutData((Object)gd);
        Label sampleFilesProjectDescription = new Label(composite, 64);
        sampleFilesProjectDescription.setText("Create a project and populate it with some example files to help you get started quickly. This also creates the recommended folder structure for organizing all of your deployable artifacts.");
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.verticalIndent = 20;
        gd.horizontalIndent = 20;
        gd.widthHint = 100;
        gd.heightHint = 80;
        sampleFilesProjectDescription.setLayoutData((Object)gd);
        final Button onlineExampleProjectButton = new Button(composite, 24);
        onlineExampleProjectButton.setImage(Activator.getImage("icons/wizards/online-example-project.png"));
        gd = new GridData(1);
        gd.horizontalIndent = 10;
        gd.verticalIndent = 20;
        onlineExampleProjectButton.setLayoutData((Object)gd);
        Label onlineExampleProjectDescription = new Label(composite, 64);
        onlineExampleProjectDescription.setText("If you have internet acces, you may select from one of several different example projects from our online repository. Examples are available ready to deploy and run on different versions of the Runtime.");
        gd = new GridData(4, 0x1000000, true, false, 1, 1);
        gd.verticalIndent = 20;
        gd.horizontalIndent = 20;
        gd.widthHint = 100;
        gd.heightHint = 80;
        onlineExampleProjectDescription.setLayoutData((Object)gd);
        emptyProjectButton.setSelection(true);
        emptyProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractKieProjectStartWizardPage.this.initialProjectContent == 0) {
                    return;
                }
                AbstractKieProjectStartWizardPage.this.initialProjectContent = 0;
                emptyProjectButton.setImage(Activator.getImage("icons/wizards/empty-project-pushed.png"));
                sampleFilesProjectButton.setImage(Activator.getImage("icons/wizards/sample-files-project.png"));
                onlineExampleProjectButton.setImage(Activator.getImage("icons/wizards/online-example-project.png"));
            }
        });
        sampleFilesProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractKieProjectStartWizardPage.this.initialProjectContent == 2) {
                    return;
                }
                AbstractKieProjectStartWizardPage.this.initialProjectContent = 2;
                emptyProjectButton.setImage(Activator.getImage("icons/wizards/empty-project.png"));
                sampleFilesProjectButton.setImage(Activator.getImage("icons/wizards/sample-files-project-pushed.png"));
                onlineExampleProjectButton.setImage(Activator.getImage("icons/wizards/online-example-project.png"));
            }
        });
        onlineExampleProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractKieProjectStartWizardPage.this.initialProjectContent == 1) {
                    return;
                }
                AbstractKieProjectStartWizardPage.this.initialProjectContent = 1;
                emptyProjectButton.setImage(Activator.getImage("icons/wizards/empty-project.png"));
                sampleFilesProjectButton.setImage(Activator.getImage("icons/wizards/sample-files-project.png"));
                onlineExampleProjectButton.setImage(Activator.getImage("icons/wizards/online-example-project-pushed.png"));
            }
        });
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return true;
    }

    public IWizardPage getNextPage() {
        return this.getProjectContentPage();
    }

    @Override
    public int getInitialProjectContent() {
        return this.initialProjectContent;
    }

    @Override
    public Collection<IProjectDescription> getNewProjectDescriptions() {
        IKieProjectWizardPage page = (IKieProjectWizardPage)this.getProjectContentPage();
        return page.getNewProjectDescriptions();
    }

    @Override
    public IRuntime getRuntime() {
        if (this.initialProjectContent == 0) {
            IKieEmptyProjectWizardPage page = (IKieEmptyProjectWizardPage)this.getWizard().getPage("NewEmptProjectPage");
            return page.getRuntime();
        }
        if (this.initialProjectContent == 2) {
            IKieSampleFilesProjectWizardPage page = (IKieSampleFilesProjectWizardPage)this.getWizard().getPage("NewSampleFilesProjectPage");
            return page.getRuntime();
        }
        if (this.initialProjectContent == 1) {
            IKieOnlineExampleProjectWizardPage page = (IKieOnlineExampleProjectWizardPage)this.getWizard().getPage("NewOnlineExampleProjectPage");
            return page.getRuntime();
        }
        return null;
    }

    @Override
    public IRuntimeManager getRuntimeManager() {
        if (this.initialProjectContent == 0) {
            IKieEmptyProjectWizardPage page = (IKieEmptyProjectWizardPage)this.getWizard().getPage("NewEmptProjectPage");
            return page.getRuntimeManager();
        }
        if (this.initialProjectContent == 2) {
            IKieSampleFilesProjectWizardPage page = (IKieSampleFilesProjectWizardPage)this.getWizard().getPage("NewSampleFilesProjectPage");
            return page.getRuntimeManager();
        }
        if (this.initialProjectContent == 1) {
            IKieOnlineExampleProjectWizardPage page = (IKieOnlineExampleProjectWizardPage)this.getWizard().getPage("NewOnlineExampleProjectPage");
            return page.getRuntimeManager();
        }
        return null;
    }

    private IWizardPage getProjectContentPage() {
        if (this.initialProjectContent == 0) {
            return this.getWizard().getPage("NewEmptProjectPage");
        }
        if (this.initialProjectContent == 2) {
            return this.getWizard().getPage("NewSampleFilesProjectPage");
        }
        if (this.initialProjectContent == 1) {
            return this.getWizard().getPage("NewOnlineExampleProjectPage");
        }
        return null;
    }

    @Override
    public IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    @Override
    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

