/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.nurserostering.domain.Assignment;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.solver.move.NurseRosterMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignmentSwitchMove
implements Move,
TabuPropertyEnabled {
    private Assignment leftAssignment;
    private Assignment rightAssignment;

    public AssignmentSwitchMove(Assignment leftAssignment, Assignment rightAssignment) {
        this.leftAssignment = leftAssignment;
        this.rightAssignment = rightAssignment;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.leftAssignment.getEmployee(), (Object)this.rightAssignment.getEmployee());
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new AssignmentSwitchMove(this.rightAssignment, this.leftAssignment);
    }

    public void doMove(WorkingMemory workingMemory) {
        Employee oldLeftEmployee = this.leftAssignment.getEmployee();
        Employee oldRightEmployee = this.rightAssignment.getEmployee();
        NurseRosterMoveHelper.moveEmployee(workingMemory, this.leftAssignment, oldRightEmployee);
        NurseRosterMoveHelper.moveEmployee(workingMemory, this.rightAssignment, oldLeftEmployee);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.leftAssignment, this.rightAssignment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AssignmentSwitchMove) {
            AssignmentSwitchMove other = (AssignmentSwitchMove)o;
            return new EqualsBuilder().append((Object)this.leftAssignment, (Object)other.leftAssignment).append((Object)this.rightAssignment, (Object)other.rightAssignment).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftAssignment).append((Object)this.rightAssignment).toHashCode();
    }

    public String toString() {
        return this.leftAssignment + " <=> " + this.rightAssignment;
    }
}

