/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.move;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.nurserostering.domain.Assignment;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.solver.move.NurseRosterMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmployeeMultipleChangeMove
implements Move,
TabuPropertyEnabled {
    private Employee fromEmployee;
    private List<Assignment> assignmentList;
    private Employee toEmployee;

    public EmployeeMultipleChangeMove(Employee fromEmployee, List<Assignment> assignmentList, Employee toEmployee) {
        this.fromEmployee = fromEmployee;
        this.assignmentList = assignmentList;
        this.toEmployee = toEmployee;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.fromEmployee, (Object)this.toEmployee);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new EmployeeMultipleChangeMove(this.toEmployee, this.assignmentList, this.fromEmployee);
    }

    public void doMove(WorkingMemory workingMemory) {
        for (Assignment assignment : this.assignmentList) {
            if (!assignment.getEmployee().equals(this.fromEmployee)) {
                throw new IllegalStateException("The assignment (" + assignment + ") should have the same employee (" + this.fromEmployee + ") as the fromEmployee (" + this.fromEmployee + ").");
            }
            NurseRosterMoveHelper.moveEmployee(workingMemory, assignment, this.toEmployee);
        }
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.assignmentList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EmployeeMultipleChangeMove) {
            EmployeeMultipleChangeMove other = (EmployeeMultipleChangeMove)o;
            return new EqualsBuilder().append((Object)this.fromEmployee, (Object)other.fromEmployee).append(this.assignmentList, other.assignmentList).append((Object)this.toEmployee, (Object)other.toEmployee).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.fromEmployee).append(this.assignmentList).append((Object)this.toEmployee).toHashCode();
    }

    public String toString() {
        return this.assignmentList + " => " + this.toEmployee;
    }
}

