/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.LocalSearchSolverScope;
import org.drools.planner.core.score.DefaultHardAndSoftScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.initializer.AbstractStartingSolutionInitializer;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.curriculumcourse.domain.Course;
import org.drools.planner.examples.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.Period;
import org.drools.planner.examples.curriculumcourse.domain.Room;
import org.drools.planner.examples.curriculumcourse.domain.UnavailablePeriodConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurriculumCourseStartingSolutionInitializer
extends AbstractStartingSolutionInitializer {
    public boolean isSolutionInitialized(LocalSearchSolverScope localSearchSolverScope) {
        CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)localSearchSolverScope.getWorkingSolution();
        return schedule.isInitialized();
    }

    public void initializeSolution(LocalSearchSolverScope localSearchSolverScope) {
        CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)localSearchSolverScope.getWorkingSolution();
        this.initializeLectureList(localSearchSolverScope, schedule);
    }

    private void initializeLectureList(LocalSearchSolverScope localSearchSolverScope, CurriculumCourseSchedule schedule) {
        List<Period> periodList = schedule.getPeriodList();
        List<Room> roomList = schedule.getRoomList();
        WorkingMemory workingMemory = localSearchSolverScope.getWorkingMemory();
        List<Lecture> lectureList = this.createLectureList(schedule);
        for (Lecture lecture : lectureList) {
            PeriodScoring periodScoring;
            Score unscheduledScore = localSearchSolverScope.calculateScoreFromWorkingMemory();
            FactHandle lectureHandle = null;
            ArrayList<PeriodScoring> periodScoringList = new ArrayList<PeriodScoring>(periodList.size());
            for (Period period : periodList) {
                if (lectureHandle == null) {
                    lecture.setPeriod(period);
                    lectureHandle = workingMemory.insert((Object)lecture);
                } else {
                    lecture.setPeriod(period);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)lectureHandle, (Object)lecture);
                }
                Score score = localSearchSolverScope.calculateScoreFromWorkingMemory();
                periodScoringList.add(new PeriodScoring(period, score));
            }
            Collections.sort(periodScoringList);
            boolean almostPerfectMatch = false;
            DefaultHardAndSoftScore bestScore = DefaultHardAndSoftScore.valueOf((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
            Period bestPeriod = null;
            Room bestRoom = null;
            Iterator i$ = periodScoringList.iterator();
            while (i$.hasNext() && bestScore.compareTo((Object)(periodScoring = (PeriodScoring)i$.next()).getScore()) < 0) {
                lecture.setPeriod(periodScoring.getPeriod());
                workingMemory.update((org.drools.runtime.rule.FactHandle)lectureHandle, (Object)lecture);
                for (Room room : roomList) {
                    lecture.setRoom(room);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)lectureHandle, (Object)lecture);
                    Score score = localSearchSolverScope.calculateScoreFromWorkingMemory();
                    if (score.compareTo((Object)unscheduledScore) < 0) {
                        if (score.compareTo((Object)bestScore) <= 0) continue;
                        bestScore = score;
                        bestPeriod = periodScoring.getPeriod();
                        bestRoom = room;
                        continue;
                    }
                    if (score.compareTo((Object)unscheduledScore) < 0) continue;
                    almostPerfectMatch = true;
                    break;
                }
                if (!almostPerfectMatch) continue;
                break;
            }
            if (!almostPerfectMatch) {
                if (bestPeriod == null || bestRoom == null) {
                    throw new IllegalStateException("The bestPeriod (" + bestPeriod + ") or the bestRoom (" + bestRoom + ") cannot be null.");
                }
                lecture.setPeriod(bestPeriod);
                lecture.setRoom(bestRoom);
                workingMemory.update((org.drools.runtime.rule.FactHandle)lectureHandle, (Object)lecture);
            }
            this.logger.debug("    Lecture ({}) initialized for starting solution.", (Object)lecture);
        }
        Collections.sort(lectureList, new PersistableIdComparator());
        schedule.setLectureList(lectureList);
    }

    public List<Lecture> createLectureList(CurriculumCourseSchedule schedule) {
        List<Course> courseList = schedule.getCourseList();
        ArrayList<CourseInitializationWeight> courseInitializationWeightList = new ArrayList<CourseInitializationWeight>(courseList.size());
        for (Course course : courseList) {
            courseInitializationWeightList.add(new CourseInitializationWeight(schedule, course));
        }
        Collections.sort(courseInitializationWeightList);
        ArrayList<Lecture> lectureList = new ArrayList<Lecture>(courseList.size() * 5);
        int lectureId = 0;
        for (CourseInitializationWeight courseInitializationWeight : courseInitializationWeightList) {
            Course course = courseInitializationWeight.getCourse();
            for (int i = 0; i < course.getLectureSize(); ++i) {
                Lecture lecture = new Lecture();
                lecture.setId(Long.valueOf(lectureId));
                ++lectureId;
                lecture.setCourse(course);
                lecture.setLectureIndexInCourse(i);
                lectureList.add(lecture);
            }
        }
        return lectureList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PeriodScoring
    implements Comparable<PeriodScoring> {
        private Period period;
        private Score score;

        private PeriodScoring(Period period, Score score) {
            this.period = period;
            this.score = score;
        }

        public Period getPeriod() {
            return this.period;
        }

        public Score getScore() {
            return this.score;
        }

        @Override
        public int compareTo(PeriodScoring other) {
            return -new CompareToBuilder().append((Object)this.score, (Object)other.score).toComparison();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CourseInitializationWeight
    implements Comparable<CourseInitializationWeight> {
        private Course course;
        private int unavailablePeriodConstraintCount;

        private CourseInitializationWeight(CurriculumCourseSchedule schedule, Course course) {
            this.course = course;
            this.unavailablePeriodConstraintCount = 0;
            for (UnavailablePeriodConstraint constraint : schedule.getUnavailablePeriodConstraintList()) {
                if (!constraint.getCourse().equals(course)) continue;
                ++this.unavailablePeriodConstraintCount;
            }
        }

        public Course getCourse() {
            return this.course;
        }

        @Override
        public int compareTo(CourseInitializationWeight other) {
            return new CompareToBuilder().append(other.course.getCurriculumList().size(), this.course.getCurriculumList().size()).append(other.unavailablePeriodConstraintCount, this.unavailablePeriodConstraintCount).append(other.course.getLectureSize(), this.course.getLectureSize()).append(other.course.getStudentSize(), this.course.getStudentSize()).append(other.course.getMinWorkingDaySize(), this.course.getMinWorkingDaySize()).append((Object)this.course.getId(), (Object)other.course.getId()).toComparison();
        }
    }
}

