/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.nurserostering.domain.Assignment;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.domain.ShiftDate;
import org.drools.planner.examples.nurserostering.solver.move.EmployeeChangeMove;

public class NurseRosteringPanel
extends SolutionPanel {
    private static final Color HEADER_COLOR = Color.YELLOW;
    private GridLayout gridLayout = new GridLayout(0, 1);

    public NurseRosteringPanel() {
        this.setLayout(this.gridLayout);
    }

    private NurseRoster getNurseRoster() {
        return (NurseRoster)this.solutionBusiness.getSolution();
    }

    public void resetPanel() {
        this.removeAll();
        NurseRoster schedule = this.getNurseRoster();
        this.gridLayout.setColumns(schedule.getShiftDateList().size() + 1);
        JLabel headerCornerLabel = new JLabel("E \\ SD");
        headerCornerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        headerCornerLabel.setBackground(HEADER_COLOR);
        headerCornerLabel.setOpaque(true);
        this.add(headerCornerLabel);
        for (ShiftDate shiftDate : schedule.getShiftDateList()) {
            JLabel shiftDateLabel = new JLabel(shiftDate.getLabel());
            shiftDateLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            shiftDateLabel.setBackground(HEADER_COLOR);
            shiftDateLabel.setOpaque(true);
            this.add(shiftDateLabel);
        }
        HashMap employeeShiftDatePanelMap = new HashMap();
        for (Employee employee : schedule.getEmployeeList()) {
            JLabel employeeLabel = new JLabel(employee.toString());
            employeeLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            employeeLabel.setBackground(HEADER_COLOR);
            employeeLabel.setOpaque(true);
            this.add(employeeLabel);
            HashMap<ShiftDate, EmployeeShiftDatePanel> shiftDatePanelMap = new HashMap<ShiftDate, EmployeeShiftDatePanel>();
            employeeShiftDatePanelMap.put(employee, shiftDatePanelMap);
            for (ShiftDate shiftDate : schedule.getShiftDateList()) {
                EmployeeShiftDatePanel employeeShiftDatePanel = new EmployeeShiftDatePanel();
                if (employee.getContract().getWeekendDefinition().isWeekend(shiftDate.getDayOfWeek())) {
                    employeeShiftDatePanel.setBackground(Color.LIGHT_GRAY);
                }
                employeeShiftDatePanel.setToolTipText("employee " + employee.getCode() + " on dayIndex " + shiftDate.getDayIndex());
                this.add(employeeShiftDatePanel);
                shiftDatePanelMap.put(shiftDate, employeeShiftDatePanel);
            }
        }
        if (schedule.isInitialized()) {
            for (Assignment assignment : schedule.getAssignmentList()) {
                Employee employee = assignment.getEmployee();
                EmployeeShiftDatePanel employeeShiftDatePanel = (EmployeeShiftDatePanel)((Map)employeeShiftDatePanelMap.get(employee)).get(assignment.getShiftDate());
                employeeShiftDatePanel.addAssignment(assignment);
            }
        }
    }

    private class AssignmentAction
    extends AbstractAction {
        private Assignment assignment;

        public AssignmentAction(Assignment assignment) {
            super(assignment.getLabel());
            this.assignment = assignment;
        }

        public void actionPerformed(ActionEvent e) {
            List<Employee> employeeList = NurseRosteringPanel.this.getNurseRoster().getEmployeeList();
            JComboBox<Object> employeeListField = new JComboBox<Object>(employeeList.toArray());
            employeeListField.setSelectedItem(this.assignment.getEmployee());
            int result = JOptionPane.showConfirmDialog(NurseRosteringPanel.this.getRootPane(), employeeListField, "Select employee", 2);
            if (result == 0) {
                Employee toEmployee = (Employee)employeeListField.getSelectedItem();
                NurseRosteringPanel.this.solutionBusiness.doMove(new EmployeeChangeMove(this.assignment, toEmployee));
                NurseRosteringPanel.this.workflowFrame.updateScreen();
            }
        }
    }

    private class EmployeeShiftDatePanel
    extends JPanel {
        public EmployeeShiftDatePanel() {
            super(new GridLayout(0, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        public void addAssignment(Assignment assignment) {
            JButton button = new JButton(new AssignmentAction(assignment));
            this.add(button);
        }
    }
}

