/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.swingui;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.drools.planner.examples.cloudbalancing.domain.CloudAssignment;
import org.drools.planner.examples.cloudbalancing.domain.CloudBalance;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.solver.move.CloudComputerChangeMove;
import org.drools.planner.examples.common.swingui.SolutionPanel;

public class CloudBalancingPanel
extends SolutionPanel {
    private static final Color HEADER_COLOR = Color.YELLOW;
    private static final int TEXT_AREA_ROWS = 4;
    private static final int TEXT_AREA_COLUMNS = 14;

    public CloudBalancingPanel() {
        this.setLayout(new GridLayout(0, 1));
    }

    private CloudBalance getCloudBalance() {
        return (CloudBalance)this.solutionBusiness.getSolution();
    }

    public void resetPanel() {
        this.removeAll();
        CloudBalance cloudBalance = this.getCloudBalance();
        this.add(this.createHeaderPanel());
        List<CloudComputer> cloudComputerList = cloudBalance.getCloudComputerList();
        HashMap<CloudComputer, CloudComputerPanel> computerToPanelMap = new HashMap<CloudComputer, CloudComputerPanel>(cloudComputerList.size());
        for (CloudComputer cloudComputer : cloudComputerList) {
            CloudComputerPanel cloudComputerPanel = new CloudComputerPanel(cloudComputer);
            computerToPanelMap.put(cloudComputer, cloudComputerPanel);
            this.add(cloudComputerPanel);
        }
        if (cloudBalance.isInitialized()) {
            for (CloudAssignment cloudAssignment : cloudBalance.getCloudAssignmentList()) {
                CloudComputer cloudComputer = cloudAssignment.getCloudComputer();
                CloudComputerPanel cloudComputerPanel = (CloudComputerPanel)computerToPanelMap.get(cloudComputer);
                cloudComputerPanel.addCloudAssignment(cloudAssignment);
            }
        }
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new FlowLayout(0));
        headerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        JTextArea cloudComputerLabel = new JTextArea("CloudComputer", 4, 14);
        cloudComputerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        cloudComputerLabel.setBackground(HEADER_COLOR);
        cloudComputerLabel.setEditable(false);
        headerPanel.add(cloudComputerLabel);
        JTextArea cloudProcessLabel = new JTextArea("CloudProcess", 4, 14);
        cloudProcessLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        cloudProcessLabel.setEditable(false);
        headerPanel.add(cloudProcessLabel);
        return headerPanel;
    }

    private class CloudAssignmentAction
    extends AbstractAction {
        private CloudAssignment cloudAssignment;

        public CloudAssignmentAction(CloudAssignment cloudAssignment) {
            super("=>");
            this.cloudAssignment = cloudAssignment;
        }

        public void actionPerformed(ActionEvent e) {
            List<CloudComputer> cloudComputerList = CloudBalancingPanel.this.getCloudBalance().getCloudComputerList();
            JComboBox<Object> cloudComputerListField = new JComboBox<Object>(cloudComputerList.toArray());
            cloudComputerListField.setSelectedItem(this.cloudAssignment.getCloudComputer());
            int result = JOptionPane.showConfirmDialog(CloudBalancingPanel.this.getRootPane(), cloudComputerListField, "Select cloud computer", 2);
            if (result == 0) {
                CloudComputer toCloudComputer = (CloudComputer)cloudComputerListField.getSelectedItem();
                CloudBalancingPanel.this.solutionBusiness.doMove(new CloudComputerChangeMove(this.cloudAssignment, toCloudComputer));
                CloudBalancingPanel.this.workflowFrame.updateScreen();
            }
        }
    }

    private class CloudComputerPanel
    extends JPanel {
        private final CloudComputer cloudComputer;

        public CloudComputerPanel(CloudComputer cloudComputer) {
            this.setLayout(new FlowLayout(0));
            this.cloudComputer = cloudComputer;
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            JTextArea cloudComputerLabel = new JTextArea(cloudComputer.getLabel(), 4, 14);
            cloudComputerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            cloudComputerLabel.setBackground(HEADER_COLOR);
            cloudComputerLabel.setEditable(false);
            this.add(cloudComputerLabel);
        }

        public void addCloudAssignment(CloudAssignment cloudAssignment) {
            JPanel cloudAssignmentPanel = new JPanel();
            cloudAssignmentPanel.setLayout(new BoxLayout(cloudAssignmentPanel, 0));
            cloudAssignmentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            JTextArea cloudAssignmentLabel = new JTextArea(cloudAssignment.getLabel(), 4, 14);
            cloudAssignmentLabel.setEditable(false);
            cloudAssignmentPanel.add(cloudAssignmentLabel);
            JButton button = new JButton(new CloudAssignmentAction(cloudAssignment));
            cloudAssignmentPanel.add(button);
            this.add(cloudAssignmentPanel);
        }
    }
}

