/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.manners2009.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.score.SimpleScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.manners2009.domain.Guest;
import org.drools.planner.examples.manners2009.domain.Hobby;
import org.drools.planner.examples.manners2009.domain.HobbyPractician;
import org.drools.planner.examples.manners2009.domain.Job;
import org.drools.planner.examples.manners2009.domain.JobType;
import org.drools.planner.examples.manners2009.domain.Seat;
import org.drools.planner.examples.manners2009.domain.SeatDesignation;
import org.drools.planner.examples.manners2009.domain.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="Manners2009")
public class Manners2009
extends AbstractPersistable
implements Solution<SimpleScore> {
    private List<Job> jobList;
    private List<Guest> guestList;
    private List<HobbyPractician> hobbyPracticianList;
    private List<Table> tableList;
    private List<Seat> seatList;
    private List<SeatDesignation> seatDesignationList;
    private SimpleScore score;

    public List<Job> getJobList() {
        return this.jobList;
    }

    public void setJobList(List<Job> jobList) {
        this.jobList = jobList;
    }

    public List<Guest> getGuestList() {
        return this.guestList;
    }

    public void setGuestList(List<Guest> guestList) {
        this.guestList = guestList;
    }

    public List<HobbyPractician> getHobbyPracticianList() {
        return this.hobbyPracticianList;
    }

    public void setHobbyPracticianList(List<HobbyPractician> hobbyPracticianList) {
        this.hobbyPracticianList = hobbyPracticianList;
    }

    public List<Table> getTableList() {
        return this.tableList;
    }

    public void setTableList(List<Table> tableList) {
        this.tableList = tableList;
    }

    public List<Seat> getSeatList() {
        return this.seatList;
    }

    public void setSeatList(List<Seat> seatList) {
        this.seatList = seatList;
    }

    public List<SeatDesignation> getSeatDesignationList() {
        return this.seatDesignationList;
    }

    public void setSeatDesignationList(List<SeatDesignation> seatDesignationList) {
        this.seatDesignationList = seatDesignationList;
    }

    public SimpleScore getScore() {
        return this.score;
    }

    public void setScore(SimpleScore score) {
        this.score = score;
    }

    public boolean isInitialized() {
        return this.seatDesignationList != null;
    }

    public Collection<? extends Object> getFacts() {
        ArrayList<Object> facts = new ArrayList<Object>();
        facts.addAll(EnumSet.allOf(JobType.class));
        facts.addAll(this.jobList);
        facts.addAll(this.guestList);
        facts.addAll(EnumSet.allOf(Hobby.class));
        facts.addAll(this.hobbyPracticianList);
        facts.addAll(this.tableList);
        facts.addAll(this.seatList);
        if (this.isInitialized()) {
            facts.addAll(this.seatDesignationList);
        }
        return facts;
    }

    public Manners2009 cloneSolution() {
        Manners2009 clone = new Manners2009();
        clone.id = this.id;
        clone.jobList = this.jobList;
        clone.guestList = this.guestList;
        clone.hobbyPracticianList = this.hobbyPracticianList;
        clone.tableList = this.tableList;
        clone.seatList = this.seatList;
        ArrayList<SeatDesignation> clonedSeatDesignationList = new ArrayList<SeatDesignation>(this.seatDesignationList.size());
        for (SeatDesignation seatDesignation : this.seatDesignationList) {
            clonedSeatDesignationList.add(seatDesignation.clone());
        }
        clone.seatDesignationList = clonedSeatDesignationList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof Manners2009)) {
            return false;
        }
        Manners2009 other = (Manners2009)o;
        if (this.seatDesignationList.size() != other.seatDesignationList.size()) {
            return false;
        }
        Iterator<SeatDesignation> it = this.seatDesignationList.iterator();
        Iterator<SeatDesignation> otherIt = other.seatDesignationList.iterator();
        while (it.hasNext()) {
            SeatDesignation otherSeatDesignation;
            SeatDesignation seatDesignation = it.next();
            if (seatDesignation.solutionEquals(otherSeatDesignation = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (SeatDesignation seatDesignation : this.seatDesignationList) {
            hashCodeBuilder.append(seatDesignation.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

