/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.score.SimpleDoubleScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.CityAssignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="TravelingSalesmanTour")
public class TravelingSalesmanTour
extends AbstractPersistable
implements Solution<SimpleDoubleScore> {
    private String name;
    private List<City> cityList;
    private City startCity;
    private List<CityAssignment> cityAssignmentList;
    private CityAssignment startCityAssignment;
    private SimpleDoubleScore score;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<City> getCityList() {
        return this.cityList;
    }

    public void setCityList(List<City> cityList) {
        this.cityList = cityList;
    }

    public City getStartCity() {
        return this.startCity;
    }

    public void setStartCity(City startCity) {
        this.startCity = startCity;
    }

    public List<CityAssignment> getCityAssignmentList() {
        return this.cityAssignmentList;
    }

    public void setCityAssignmentList(List<CityAssignment> cityAssignmentList) {
        this.cityAssignmentList = cityAssignmentList;
    }

    public CityAssignment getStartCityAssignment() {
        return this.startCityAssignment;
    }

    public void setStartCityAssignment(CityAssignment startCityAssignment) {
        this.startCityAssignment = startCityAssignment;
    }

    public SimpleDoubleScore getScore() {
        return this.score;
    }

    public void setScore(SimpleDoubleScore score) {
        this.score = score;
    }

    public boolean isInitialized() {
        return this.cityAssignmentList != null;
    }

    public Collection<? extends Object> getFacts() {
        ArrayList<AbstractPersistable> facts = new ArrayList<AbstractPersistable>();
        facts.addAll(this.cityList);
        facts.add(this.startCity);
        if (this.isInitialized()) {
            facts.addAll(this.cityAssignmentList);
            facts.add(this.startCityAssignment);
        }
        return facts;
    }

    public TravelingSalesmanTour cloneSolution() {
        TravelingSalesmanTour clone = new TravelingSalesmanTour();
        clone.id = this.id;
        clone.name = this.name;
        clone.cityList = this.cityList;
        clone.startCity = this.startCity;
        ArrayList<CityAssignment> clonedCityAssignmentList = new ArrayList<CityAssignment>(this.cityAssignmentList.size());
        HashMap<Long, CityAssignment> idToClonedCityAssignmentMap = new HashMap<Long, CityAssignment>(this.cityAssignmentList.size());
        for (CityAssignment cityAssignment : this.cityAssignmentList) {
            CityAssignment clonedCityAssignment = cityAssignment.clone();
            clonedCityAssignmentList.add(clonedCityAssignment);
            idToClonedCityAssignmentMap.put(clonedCityAssignment.getId(), clonedCityAssignment);
            if (cityAssignment != this.startCityAssignment) continue;
            clone.startCityAssignment = clonedCityAssignment;
        }
        for (CityAssignment clonedCityAssignment : clonedCityAssignmentList) {
            clonedCityAssignment.setPreviousCityAssignment((CityAssignment)idToClonedCityAssignmentMap.get(clonedCityAssignment.getPreviousCityAssignment().getId()));
            clonedCityAssignment.setNextCityAssignment((CityAssignment)idToClonedCityAssignmentMap.get(clonedCityAssignment.getNextCityAssignment().getId()));
        }
        clone.cityAssignmentList = clonedCityAssignmentList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof TravelingSalesmanTour)) {
            return false;
        }
        TravelingSalesmanTour other = (TravelingSalesmanTour)o;
        if (this.cityAssignmentList.size() != other.cityAssignmentList.size()) {
            return false;
        }
        Iterator<CityAssignment> it = this.cityAssignmentList.iterator();
        Iterator<CityAssignment> otherIt = other.cityAssignmentList.iterator();
        while (it.hasNext()) {
            CityAssignment otherCityAssignment;
            CityAssignment cityAssignment = it.next();
            if (cityAssignment.solutionEquals(otherCityAssignment = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (CityAssignment cityAssignment : this.cityAssignmentList) {
            hashCodeBuilder.append(cityAssignment.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

