/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractSolutionImporter;
import org.drools.planner.examples.common.persistence.SolutionDao;

public abstract class AbstractTxtSolutionImporter
extends AbstractSolutionImporter {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = ".txt";

    protected AbstractTxtSolutionImporter(SolutionDao solutionDao) {
        super(solutionDao);
    }

    protected String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    public abstract TxtInputBuilder createTxtInputBuilder();

    public Solution readSolution(File inputFile) {
        Solution solution;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(inputFile));
            TxtInputBuilder txtInputBuilder = this.createTxtInputBuilder();
            txtInputBuilder.setBufferedReader(bufferedReader);
            solution = txtInputBuilder.readSolution();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Could not read the file (" + inputFile.getName() + ").", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
        return solution;
    }

    public abstract class TxtInputBuilder {
        protected BufferedReader bufferedReader;

        public void setBufferedReader(BufferedReader bufferedReader) {
            this.bufferedReader = bufferedReader;
        }

        public abstract Solution readSolution() throws IOException;

        public void readEmptyLine() throws IOException {
            this.readConstantLine("");
        }

        public void readConstantLine(String constantValue) throws IOException {
            String line = this.bufferedReader.readLine();
            String value = line.trim();
            if (!value.equals(constantValue)) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to be a constant value (" + constantValue + ").");
            }
        }

        public int readIntegerValue() throws IOException {
            return this.readIntegerValue("");
        }

        public int readIntegerValue(String prefix) throws IOException {
            return this.readIntegerValue(prefix, "");
        }

        public int readIntegerValue(String prefix, String suffix) throws IOException {
            String line = this.bufferedReader.readLine();
            String value = line.trim();
            if (!value.startsWith(prefix)) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to start with prefix (" + prefix + ").");
            }
            if (!(value = value.substring(prefix.length())).endsWith(suffix)) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to end with suffix (" + suffix + ").");
            }
            value = value.substring(0, value.length() - suffix.length());
            value = value.trim();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Read line (" + line + ") is expected to contain an integer value (" + value + ").", e);
            }
        }
    }
}

