/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.curriculumcourse.domain.Course;
import org.drools.planner.examples.curriculumcourse.domain.Curriculum;
import org.drools.planner.examples.curriculumcourse.domain.Day;
import org.drools.planner.examples.curriculumcourse.domain.Period;
import org.drools.planner.examples.curriculumcourse.domain.Room;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="Lecture")
public class Lecture
extends AbstractPersistable
implements Comparable<Lecture> {
    private Course course;
    private int lectureIndexInCourse;
    private Period period;
    private Room room;

    public Course getCourse() {
        return this.course;
    }

    public void setCourse(Course course) {
        this.course = course;
    }

    public int getLectureIndexInCourse() {
        return this.lectureIndexInCourse;
    }

    public void setLectureIndexInCourse(int lectureIndexInCourse) {
        this.lectureIndexInCourse = lectureIndexInCourse;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public String getLabel() {
        return this.course + "-" + this.lectureIndexInCourse;
    }

    public int getStudentSize() {
        return this.course.getStudentSize();
    }

    public List<Curriculum> getCurriculumList() {
        return this.course.getCurriculumList();
    }

    public Day getDay() {
        return this.period.getDay();
    }

    public int getTimeslotIndex() {
        return this.period.getTimeslot().getTimeslotIndex();
    }

    @Override
    public int compareTo(Lecture other) {
        return new CompareToBuilder().append((Object)this.period, (Object)other.period).append((Object)this.room, (Object)other.room).append((Object)this.course, (Object)other.course).toComparison();
    }

    public Lecture clone() {
        Lecture clone = new Lecture();
        clone.id = this.id;
        clone.course = this.course;
        clone.lectureIndexInCourse = this.lectureIndexInCourse;
        clone.period = this.period;
        clone.room = this.room;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Lecture) {
            Lecture other = (Lecture)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.course, (Object)other.course).append((Object)this.period, (Object)other.period).append((Object)this.room, (Object)other.room).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.course).append((Object)this.period).append((Object)this.room).toHashCode();
    }

    @Override
    public String toString() {
        return this.course + "-" + this.lectureIndexInCourse + " @ " + this.period + " + " + this.room;
    }
}

