/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.manners2009.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.manners2009.domain.HobbyPractician;
import org.drools.planner.examples.manners2009.domain.Manners2009;
import org.drools.planner.examples.manners2009.domain.Seat;
import org.drools.planner.examples.manners2009.domain.SeatDesignation;
import org.drools.planner.examples.manners2009.domain.Table;
import org.drools.planner.examples.manners2009.solver.move.SeatDesignationSwitchMove;

public class Manners2009Panel
extends SolutionPanel {
    private GridLayout gridLayout = new GridLayout(0, 1);

    public Manners2009Panel() {
        this.setLayout(this.gridLayout);
    }

    private Manners2009 getManners2009() {
        return (Manners2009)this.solutionBusiness.getSolution();
    }

    public void resetPanel() {
        this.removeAll();
        Manners2009 manners2009 = this.getManners2009();
        this.gridLayout.setColumns((int)Math.ceil(Math.sqrt(manners2009.getTableList().size())));
        HashMap<Table, JPanel> tablePanelMap = new HashMap<Table, JPanel>(manners2009.getTableList().size());
        HashMap<Seat, SeatPanel> seatPanelMap = new HashMap<Seat, SeatPanel>(manners2009.getSeatList().size());
        for (Table table : manners2009.getTableList()) {
            int edgeLength = (int)Math.ceil((double)(table.getSeatList().size() + 4) / 4.0);
            JPanel tablePanel = new JPanel(new GridLayout(0, edgeLength));
            tablePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder("Table " + table.getTableIndex())));
            this.add(tablePanel);
            tablePanelMap.put(table, tablePanel);
            for (int y = 0; y < edgeLength; ++y) {
                for (int x = 0; x < edgeLength; ++x) {
                    int index = y == 0 ? x : (x == edgeLength - 1 ? edgeLength - 1 + y : (y == edgeLength - 1 ? 2 * (edgeLength - 1) + (edgeLength - 1 - x) : (x == 0 ? 3 * (edgeLength - 1) + (edgeLength - 1 - y) : Integer.MAX_VALUE)));
                    if (index < table.getSeatList().size()) {
                        Seat seat = table.getSeatList().get(index);
                        SeatPanel seatPanel = new SeatPanel(seat);
                        tablePanel.add(seatPanel);
                        seatPanelMap.put(seat, seatPanel);
                        continue;
                    }
                    tablePanel.add(new JPanel());
                }
            }
        }
        if (manners2009.isInitialized()) {
            for (SeatDesignation seatDesignation : manners2009.getSeatDesignationList()) {
                SeatPanel seatPanel = (SeatPanel)seatPanelMap.get(seatDesignation.getSeat());
                seatPanel.addSeatDesignation(seatDesignation);
            }
        }
    }

    private class SeatDesignationAction
    extends AbstractAction {
        private SeatDesignation seatDesignation;

        public SeatDesignationAction(SeatDesignation seatDesignation) {
            super(seatDesignation.getGuest().getCode() + "(" + seatDesignation.getGuest().getGender().getCode() + ")");
            this.seatDesignation = seatDesignation;
        }

        public void actionPerformed(ActionEvent e) {
            List<SeatDesignation> seatDesignationList = Manners2009Panel.this.getManners2009().getSeatDesignationList();
            JComboBox<Object> seatDesignationListField = new JComboBox<Object>(seatDesignationList.toArray());
            seatDesignationListField.setSelectedItem(this.seatDesignation);
            int result = JOptionPane.showConfirmDialog(Manners2009Panel.this.getRootPane(), seatDesignationListField, "Select seat designation to switch with", 2);
            if (result == 0) {
                SeatDesignation switchSeatDesignation = (SeatDesignation)seatDesignationListField.getSelectedItem();
                Manners2009Panel.this.solutionBusiness.doMove(new SeatDesignationSwitchMove(this.seatDesignation, switchSeatDesignation));
                Manners2009Panel.this.workflowFrame.updateScreen();
            }
        }
    }

    private class SeatPanel
    extends JPanel {
        public SeatPanel(Seat seat) {
            super(new GridLayout(0, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            JLabel seatLabel = new JLabel("Seat " + seat.getSeatIndexInTable(), 0);
            this.add(seatLabel);
        }

        public void addSeatDesignation(SeatDesignation seatDesignation) {
            JButton button = new JButton(new SeatDesignationAction(seatDesignation));
            this.add(button);
            this.add(new JLabel(seatDesignation.getGuest().getJob().getJobType().getCode() + ": " + seatDesignation.getGuest().getJob().getName(), 0));
            StringBuilder hobbyString = new StringBuilder();
            for (HobbyPractician hobbyPractician : seatDesignation.getGuest().getHobbyPracticianList()) {
                if (hobbyString.length() > 0) {
                    hobbyString.append(", ");
                }
                hobbyString.append(hobbyPractician.getHobby().toString());
            }
            this.add(new JLabel(hobbyString.toString(), 0));
        }
    }
}

