/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.competition;

import java.io.File;
import java.util.Arrays;
import org.drools.planner.config.XmlSolverConfigurer;
import org.drools.planner.config.localsearch.LocalSearchSolverConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.app.LoggingMain;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.persistence.NurseRosteringSolutionExporter;
import org.drools.planner.examples.nurserostering.persistence.NurseRosteringSolutionImporter;

public class NurseRosteringCompetitionLongApp
extends LoggingMain {
    public static final String SOLVER_CONFIG = "/org/drools/planner/examples/nurserostering/competition/nurseRosteringCompetitionLongSolverConfig.xml";
    private static final int DEFAULT_TIME_SECONDS_SPEND = 36000;
    private static final String INPUT_FILE_NAME_PREFIX = "long";
    protected NurseRosteringSolutionImporter importer;
    protected NurseRosteringSolutionExporter exporter;
    protected Solver solver;
    protected File inputDir = new File("input");
    protected File outputDir;

    public static void main(String[] args) {
        long maximumSecondsSpend;
        if (args.length > 1) {
            throw new IllegalArgumentException("Only one argument (maximumSecondsSpend) is allowed.");
        }
        if (args.length == 1) {
            try {
                maximumSecondsSpend = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The argument maximumSecondsSpend (" + args[0] + ") is not a number.");
            }
        } else {
            maximumSecondsSpend = 36000L;
        }
        new NurseRosteringCompetitionLongApp(maximumSecondsSpend).solve();
    }

    public NurseRosteringCompetitionLongApp(long maximumSecondsSpend) {
        if (!this.inputDir.exists()) {
            throw new IllegalArgumentException("The input directory  (" + this.inputDir + ") does not exist.");
        }
        this.outputDir = new File("output");
        if (!this.outputDir.exists()) {
            throw new IllegalArgumentException("The output directory (" + this.outputDir + ") does not exist.");
        }
        this.importer = new NurseRosteringSolutionImporter();
        this.exporter = new NurseRosteringSolutionExporter();
        XmlSolverConfigurer configurer = new XmlSolverConfigurer();
        configurer.configure(SOLVER_CONFIG);
        ((LocalSearchSolverConfig)configurer.getConfig()).getTerminationConfig().setMaximumSecondsSpend(Long.valueOf(maximumSecondsSpend));
        this.solver = configurer.buildSolver();
    }

    private void solve() {
        Object[] inputFiles = this.inputDir.listFiles();
        if (inputFiles == null) {
            throw new IllegalArgumentException("The input directory  (" + this.inputDir + ") does not exist.");
        }
        Arrays.sort(inputFiles);
        for (Object inputFile : inputFiles) {
            String inputFileName = ((File)inputFile).getName();
            if (!inputFileName.toLowerCase().endsWith(".xml") || !inputFileName.toLowerCase().startsWith(INPUT_FILE_NAME_PREFIX)) continue;
            this.logger.info("Solving {}", (Object)inputFileName);
            NurseRoster startingSolution = (NurseRoster)this.importer.readSolution((File)inputFile);
            this.solver.setStartingSolution((Solution)startingSolution);
            this.solver.solve();
            NurseRoster bestSolution = (NurseRoster)this.solver.getBestSolution();
            File outputFile = new File(this.outputDir, inputFileName.substring(0, inputFileName.length() - 4) + "_geoffrey_de_smet.xml");
            this.exporter.writeSolution(bestSolution, outputFile);
        }
        this.logger.info("Done");
    }
}

