/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.competition;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.drools.planner.core.score.HardAndSoftScore;
import org.drools.planner.examples.common.app.LoggingMain;
import org.drools.planner.examples.common.business.SolutionBusiness;
import org.drools.planner.examples.nurserostering.app.NurseRosteringApp;

public class NurseRosteringEvaluatorHelper
extends LoggingMain {
    private static final boolean ALL_INPUT_FILES = true;
    private static final String INPUT_FILE_PREFIX = "long_late04";
    private static final String OUTPUT_FILE_SUFFIX = "_geoffrey_de_smet";
    private static final String DEFAULT_LINE_CONTAINS_FILTER = null;
    protected NurseRosteringApp nurseRosteringApp = new NurseRosteringApp();
    protected SolutionBusiness solutionBusiness = this.nurseRosteringApp.createSolutionBusiness();

    public static void main(String[] args) {
        String lineContainsFilter = args.length > 0 ? args[0] : DEFAULT_LINE_CONTAINS_FILTER;
        NurseRosteringEvaluatorHelper helper = new NurseRosteringEvaluatorHelper();
        File inputDir = helper.getImportDir();
        Object[] inputFiles = inputDir.listFiles();
        if (inputFiles == null) {
            throw new IllegalArgumentException("Your working dir should be drools-planner-examples and contain: " + inputDir);
        }
        Arrays.sort(inputFiles);
        for (Object inputFile : inputFiles) {
            String inputFileName = ((File)inputFile).getName();
            if (!inputFileName.endsWith(".xml")) continue;
            String filePrefix = inputFileName.substring(0, inputFileName.lastIndexOf(".xml"));
            helper.evaluate(filePrefix, OUTPUT_FILE_SUFFIX, lineContainsFilter);
        }
    }

    public File getImportDir() {
        return this.solutionBusiness.getImportDataDir();
    }

    public void evaluate(String filePrefix, String fileSuffix, String lineContainsFilter) {
        block9: {
            Process process = null;
            try {
                File inputFile = new File(this.solutionBusiness.getImportDataDir(), filePrefix + ".xml").getCanonicalFile();
                File solvedFile = new File(this.solutionBusiness.getSolvedDataDir(), filePrefix + fileSuffix + ".xml").getCanonicalFile();
                if (!solvedFile.exists()) {
                    this.logger.info("Skipping inputFile ({}) because no solvedFile found.", (Object)inputFile);
                    return;
                }
                this.solutionBusiness.openSolution(solvedFile);
                HardAndSoftScore score = (HardAndSoftScore)this.solutionBusiness.getScore();
                File outputFile = new File(this.solutionBusiness.getExportDataDir(), filePrefix + fileSuffix + ".xml").getCanonicalFile();
                this.solutionBusiness.exportSolution(outputFile);
                File evaluatorDir = new File("local/competition/nurserostering/");
                String command = "java -jar evaluator.jar " + inputFile.getAbsolutePath() + " " + outputFile.getAbsolutePath();
                process = Runtime.getRuntime().exec(command, null, evaluatorDir);
                EvaluatorSummaryFilterOutputStream out = new EvaluatorSummaryFilterOutputStream(outputFile.getName(), lineContainsFilter);
                IOUtils.copy((InputStream)process.getInputStream(), (OutputStream)out);
                IOUtils.copy((InputStream)process.getErrorStream(), (OutputStream)System.err);
                out.writeResults();
                int penaltyTotal = out.getPenaltyTotal();
                if (score.getHardScore() != 0) break block9;
                if (score.getSoftScore() == -penaltyTotal) {
                    System.out.println("The calculated soft score (" + score.getSoftScore() + ") is the same as the evaluator penalty total (" + penaltyTotal + ").");
                    break block9;
                }
                throw new IllegalStateException("The calculated soft score (" + score.getSoftScore() + ") is not the same as the evaluator penalty total (" + penaltyTotal + ").");
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
    }

    private static class EvaluatorSummaryFilterOutputStream
    extends OutputStream {
        private String name;
        private String lineContainsFilter;
        private StringBuilder lineBuffer = new StringBuilder(120);
        private Map<String, int[]> costMap = new TreeMap<String, int[]>();
        private String lastEmployeeCode = null;
        private int penaltyTotal;

        private EvaluatorSummaryFilterOutputStream(String name, String lineContainsFilter) {
            this.name = name;
            this.lineContainsFilter = lineContainsFilter;
        }

        public int getPenaltyTotal() {
            return this.penaltyTotal;
        }

        public void write(int c) throws IOException {
            if (c == 10) {
                String line = this.lineBuffer.toString();
                this.lineBuffer.delete(0, this.lineBuffer.length());
                this.processLine(line);
            } else {
                this.lineBuffer.append((char)c);
            }
        }

        private void processLine(String line) {
            int employeeIndex = line.indexOf("Employee: ");
            if (employeeIndex >= 0) {
                this.lastEmployeeCode = line.substring(employeeIndex).replaceAll("Employee: (.+)", "$1");
            } else if (line.contains("Penalty:")) {
                this.lastEmployeeCode = null;
            }
            if (this.lineContainsFilter == null || line.contains(this.lineContainsFilter)) {
                int excessIndex = line.indexOf("excess = ");
                if (excessIndex >= 0) {
                    String key = line.substring(0, excessIndex);
                    int costIndex = line.indexOf("cost = ");
                    int value = Integer.parseInt((line.substring(costIndex) + " ").replaceAll("cost = (\\d+) .*", "$1"));
                    int[] cost = this.costMap.get(key);
                    if (cost == null) {
                        cost = new int[]{1, value};
                        this.costMap.put(key, cost);
                    } else {
                        cost[0] = cost[0] + 1;
                        cost[1] = cost[1] + value;
                    }
                }
                if (this.lastEmployeeCode != null) {
                    System.out.print("E(" + this.lastEmployeeCode + ")  ");
                }
                System.out.println(line);
            }
        }

        public void writeResults() {
            System.out.println("EvaluatorHelper results for " + this.name);
            this.penaltyTotal = 0;
            if (this.lineContainsFilter != null) {
                System.out.println("with lineContainsFilter (" + this.lineContainsFilter + ")");
            }
            for (Map.Entry<String, int[]> entry : this.costMap.entrySet()) {
                int[] cost = entry.getValue();
                this.penaltyTotal += cost[1];
                System.out.println(entry.getKey() + " count = " + cost[0] + " total = " + cost[1]);
            }
            System.out.println("The penaltyTotal: " + this.penaltyTotal);
        }
    }
}

