/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.annotations.PlanningValueProperty;
import org.drools.planner.core.annotations.PlanningVariableClass;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.common.domain.AbstractPersistable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PlanningVariableClass
@XStreamAlias(value="CloudAssignment")
public class CloudAssignment
extends AbstractPersistable
implements Comparable<CloudAssignment> {
    private CloudProcess cloudProcess;
    private CloudComputer cloudComputer;

    public CloudProcess getCloudProcess() {
        return this.cloudProcess;
    }

    public void setCloudProcess(CloudProcess cloudProcess) {
        this.cloudProcess = cloudProcess;
    }

    public CloudComputer getCloudComputer() {
        return this.cloudComputer;
    }

    @PlanningValueProperty
    public void setCloudComputer(CloudComputer cloudComputer) {
        this.cloudComputer = cloudComputer;
    }

    public String getLabel() {
        return this.cloudProcess.getLabel();
    }

    public int getMinimalCpuPower() {
        return this.cloudProcess.getMinimalCpuPower();
    }

    public int getMinimalMemory() {
        return this.cloudProcess.getMinimalMemory();
    }

    public int getMinimalNetworkBandwidth() {
        return this.cloudProcess.getMinimalNetworkBandwidth();
    }

    @Override
    public int compareTo(CloudAssignment other) {
        return new CompareToBuilder().append((Object)this.cloudProcess, (Object)other.cloudProcess).append((Object)this.cloudComputer, (Object)other.cloudComputer).toComparison();
    }

    public CloudAssignment clone() {
        CloudAssignment clone = new CloudAssignment();
        clone.id = this.id;
        clone.cloudProcess = this.cloudProcess;
        clone.cloudComputer = this.cloudComputer;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudAssignment) {
            CloudAssignment other = (CloudAssignment)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.cloudProcess, (Object)other.cloudProcess).append((Object)this.cloudComputer, (Object)other.cloudComputer).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.cloudProcess).append((Object)this.cloudComputer).toHashCode();
    }

    @Override
    public String toString() {
        return this.cloudProcess + "->" + this.cloudComputer;
    }
}

