/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.nurserostering.domain.Assignment;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.solver.move.NurseRosteringMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmployeeChangeMove
implements Move,
TabuPropertyEnabled {
    private Assignment assignment;
    private Employee toEmployee;

    public EmployeeChangeMove(Assignment assignment, Employee toEmployee) {
        this.assignment = assignment;
        this.toEmployee = toEmployee;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.assignment.getEmployee(), (Object)this.toEmployee);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new EmployeeChangeMove(this.assignment, this.assignment.getEmployee());
    }

    public void doMove(WorkingMemory workingMemory) {
        NurseRosteringMoveHelper.moveEmployee(workingMemory, this.assignment, this.toEmployee);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.assignment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EmployeeChangeMove) {
            EmployeeChangeMove other = (EmployeeChangeMove)o;
            return new EqualsBuilder().append((Object)this.assignment, (Object)other.assignment).append((Object)this.toEmployee, (Object)other.toEmployee).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.assignment).append((Object)this.toEmployee).toHashCode();
    }

    public String toString() {
        return this.assignment + " => " + this.toEmployee;
    }
}

