/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.Examination;
import org.drools.planner.examples.examination.domain.Period;
import org.drools.planner.examples.examination.domain.Room;
import org.drools.planner.examples.examination.solver.move.PeriodChangeMove;
import org.drools.planner.examples.examination.solver.move.RoomChangeMove;

public class ExaminationPanel
extends SolutionPanel {
    private static final Color HEADER_COLOR = Color.YELLOW;
    private GridLayout gridLayout = new GridLayout(0, 1);

    public ExaminationPanel() {
        this.setLayout(this.gridLayout);
    }

    private Examination getExamination() {
        return (Examination)this.solutionBusiness.getSolution();
    }

    public void resetPanel() {
        this.removeAll();
        Examination examination = this.getExamination();
        this.gridLayout.setColumns(examination.getRoomList().size() + 1);
        JLabel headerCornerLabel = new JLabel("Period         \\         Room");
        headerCornerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        headerCornerLabel.setBackground(HEADER_COLOR);
        headerCornerLabel.setOpaque(true);
        this.add(headerCornerLabel);
        for (Room room : examination.getRoomList()) {
            JLabel roomLabel = new JLabel(room.toString());
            roomLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            roomLabel.setBackground(HEADER_COLOR);
            roomLabel.setOpaque(true);
            this.add(roomLabel);
        }
        HashMap periodRoomPanelMap = new HashMap();
        for (Period period : examination.getPeriodList()) {
            JLabel periodLabel = new JLabel(period.toString() + " " + period.getStartDateTimeString());
            periodLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            periodLabel.setBackground(HEADER_COLOR);
            periodLabel.setOpaque(true);
            this.add(periodLabel);
            HashMap<Room, PeriodRoomPanel> roomPanelMap = new HashMap<Room, PeriodRoomPanel>();
            periodRoomPanelMap.put(period, roomPanelMap);
            for (Room room : examination.getRoomList()) {
                PeriodRoomPanel periodRoomPanel = new PeriodRoomPanel();
                this.add(periodRoomPanel);
                roomPanelMap.put(room, periodRoomPanel);
            }
        }
        if (examination.isInitialized()) {
            for (Exam exam : examination.getExamList()) {
                PeriodRoomPanel periodRoomPanel = (PeriodRoomPanel)((Map)periodRoomPanelMap.get(exam.getPeriod())).get(exam.getRoom());
                periodRoomPanel.addExam(exam);
            }
        }
    }

    private class ExamAction
    extends AbstractAction {
        private Exam exam;

        public ExamAction(Exam exam) {
            super(exam.getTopic().toString());
            this.exam = exam;
        }

        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 1));
            List<Period> periodList = ExaminationPanel.this.getExamination().getPeriodList();
            JComboBox<Object> periodListField = new JComboBox<Object>(periodList.toArray());
            periodListField.setSelectedItem(this.exam.getPeriod());
            listFieldsPanel.add(periodListField);
            List<Room> roomList = ExaminationPanel.this.getExamination().getRoomList();
            JComboBox<Object> roomListField = new JComboBox<Object>(roomList.toArray());
            roomListField.setSelectedItem(this.exam.getRoom());
            listFieldsPanel.add(roomListField);
            int result = JOptionPane.showConfirmDialog(ExaminationPanel.this.getRootPane(), listFieldsPanel, "Select period and room", 2);
            if (result == 0) {
                Period toPeriod = (Period)periodListField.getSelectedItem();
                ExaminationPanel.this.solutionBusiness.doMove(new PeriodChangeMove(this.exam, toPeriod));
                Room toRoom = (Room)roomListField.getSelectedItem();
                ExaminationPanel.this.solutionBusiness.doMove(new RoomChangeMove(this.exam, toRoom));
                ExaminationPanel.this.workflowFrame.updateScreen();
            }
        }
    }

    private class PeriodRoomPanel
    extends JPanel {
        public PeriodRoomPanel() {
            super(new GridLayout(0, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        public void addExam(Exam exam) {
            JButton button = new JButton(new ExamAction(exam));
            this.add(button);
        }
    }
}

