/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.score.DefaultSimpleDoubleScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.initializer.AbstractStartingSolutionInitializer;
import org.drools.planner.core.solver.AbstractSolverScope;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.CityAssignment;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TspStartingSolutionInitializer
extends AbstractStartingSolutionInitializer {
    public boolean isSolutionInitialized(AbstractSolverScope abstractSolverScope) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)abstractSolverScope.getWorkingSolution();
        return travelingSalesmanTour.isInitialized();
    }

    public void initializeSolution(AbstractSolverScope abstractSolverScope) {
        TravelingSalesmanTour travelingSalesmanTour = (TravelingSalesmanTour)abstractSolverScope.getWorkingSolution();
        this.initializeCityAssignmentList(abstractSolverScope, travelingSalesmanTour);
    }

    private void initializeCityAssignmentList(AbstractSolverScope abstractSolverScope, TravelingSalesmanTour travelingSalesmanTour) {
        City startCity = travelingSalesmanTour.getStartCity();
        WorkingMemory workingMemory = abstractSolverScope.getWorkingMemory();
        List<CityAssignment> cityAssignmentList = this.createCityAssignmentList(travelingSalesmanTour);
        ArrayList<CityAssignment> assignedCityAssignmentList = null;
        for (CityAssignment cityAssignment : cityAssignmentList) {
            FactHandle cityAssignmentHandle = null;
            if (assignedCityAssignmentList == null) {
                assignedCityAssignmentList = new ArrayList<CityAssignment>(cityAssignmentList.size());
                cityAssignment.setNextCityAssignment(cityAssignment);
                cityAssignment.setPreviousCityAssignment(cityAssignment);
                cityAssignmentHandle = workingMemory.insert((Object)cityAssignment);
            } else {
                DefaultSimpleDoubleScore bestScore = DefaultSimpleDoubleScore.valueOf((double)-1.7976931348623157E308);
                CityAssignment bestAfterCityAssignment = null;
                FactHandle bestAfterCityAssignmentFactHandle = null;
                CityAssignment bestBeforeCityAssignment = null;
                FactHandle bestBeforeCityAssignmentFactHandle = null;
                for (CityAssignment afterCityAssignment : assignedCityAssignmentList) {
                    CityAssignment beforeCityAssignment = afterCityAssignment.getNextCityAssignment();
                    FactHandle afterCityAssignmentFactHandle = workingMemory.getFactHandle((Object)afterCityAssignment);
                    FactHandle beforeCityAssignmentFactHandle = workingMemory.getFactHandle((Object)beforeCityAssignment);
                    afterCityAssignment.setNextCityAssignment(cityAssignment);
                    cityAssignment.setPreviousCityAssignment(afterCityAssignment);
                    cityAssignment.setNextCityAssignment(beforeCityAssignment);
                    beforeCityAssignment.setPreviousCityAssignment(cityAssignment);
                    if (cityAssignmentHandle == null) {
                        cityAssignmentHandle = workingMemory.insert((Object)cityAssignment);
                    } else {
                        workingMemory.update((org.drools.runtime.rule.FactHandle)cityAssignmentHandle, (Object)cityAssignment);
                    }
                    workingMemory.update((org.drools.runtime.rule.FactHandle)afterCityAssignmentFactHandle, (Object)afterCityAssignment);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)beforeCityAssignmentFactHandle, (Object)beforeCityAssignment);
                    Score score = abstractSolverScope.calculateScoreFromWorkingMemory();
                    if (score.compareTo((Object)bestScore) > 0) {
                        bestScore = score;
                        bestAfterCityAssignment = afterCityAssignment;
                        bestAfterCityAssignmentFactHandle = afterCityAssignmentFactHandle;
                        bestBeforeCityAssignment = beforeCityAssignment;
                        bestBeforeCityAssignmentFactHandle = beforeCityAssignmentFactHandle;
                    }
                    afterCityAssignment.setNextCityAssignment(beforeCityAssignment);
                    beforeCityAssignment.setPreviousCityAssignment(afterCityAssignment);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)afterCityAssignmentFactHandle, (Object)afterCityAssignment);
                    workingMemory.update((org.drools.runtime.rule.FactHandle)beforeCityAssignmentFactHandle, (Object)beforeCityAssignment);
                }
                if (bestAfterCityAssignment == null) {
                    throw new IllegalStateException("The bestAfterCityAssignment (" + bestAfterCityAssignment + ") cannot be null.");
                }
                bestAfterCityAssignment.setNextCityAssignment(cityAssignment);
                cityAssignment.setPreviousCityAssignment(bestAfterCityAssignment);
                cityAssignment.setNextCityAssignment(bestBeforeCityAssignment);
                bestBeforeCityAssignment.setPreviousCityAssignment(cityAssignment);
                workingMemory.update((org.drools.runtime.rule.FactHandle)cityAssignmentHandle, (Object)cityAssignment);
                workingMemory.update(bestAfterCityAssignmentFactHandle, (Object)bestAfterCityAssignment);
                workingMemory.update(bestBeforeCityAssignmentFactHandle, (Object)bestBeforeCityAssignment);
            }
            assignedCityAssignmentList.add(cityAssignment);
            if (cityAssignment.getCity() == startCity) {
                travelingSalesmanTour.setStartCityAssignment(cityAssignment);
            }
            this.logger.debug("    CityAssignment ({}) initialized for starting solution.", (Object)cityAssignment);
        }
        Collections.sort(cityAssignmentList, new PersistableIdComparator());
        travelingSalesmanTour.setCityAssignmentList(cityAssignmentList);
    }

    public List<CityAssignment> createCityAssignmentList(TravelingSalesmanTour travelingSalesmanTour) {
        List<City> cityList = travelingSalesmanTour.getCityList();
        ArrayList<CityAssignment> cityAssignmentList = new ArrayList<CityAssignment>(cityList.size());
        int cityAssignmentId = 0;
        for (City city : cityList) {
            CityAssignment cityAssignment = new CityAssignment();
            cityAssignment.setId(Long.valueOf(cityAssignmentId));
            cityAssignment.setCity(city);
            cityAssignmentList.add(cityAssignment);
            ++cityAssignmentId;
        }
        return cityAssignmentList;
    }
}

