/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.drools.planner.examples.tsp.domain.City;
import org.drools.planner.examples.tsp.domain.CityAssignment;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.swingui.TspPanel;

public class TspWorldPanel
extends JPanel {
    private final TspPanel tspPanel;
    private BufferedImage canvas = null;

    public TspWorldPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
    }

    public void resetPanel() {
        TravelingSalesmanTour travelingSalesmanTour = this.tspPanel.getTravelingSalesmanTour();
        double srcMinimumX = Double.MAX_VALUE;
        double srcMaximumX = -1.7976931348623157E308;
        double srcMinimumY = Double.MAX_VALUE;
        double srcMaximumY = -1.7976931348623157E308;
        for (City city : travelingSalesmanTour.getCityList()) {
            double y;
            double x = city.getX();
            if (x < srcMinimumX) {
                srcMinimumX = x;
            }
            if (x > srcMaximumX) {
                srcMaximumX = x;
            }
            if ((y = city.getY()) < srcMinimumY) {
                srcMinimumY = y;
            }
            if (!(y > srcMaximumY)) continue;
            srcMaximumY = y;
        }
        double srcWidth = srcMaximumX - srcMinimumX;
        double srcHeight = srcMaximumY - srcMinimumY;
        Dimension size = this.getSize();
        double width = size.getWidth();
        double height = size.getHeight();
        int canvasWidth = (int)Math.ceil(width) + 1;
        int canvasHeight = (int)Math.ceil(height) + 1;
        this.canvas = new BufferedImage(canvasWidth, canvasHeight, 1);
        Graphics g = this.canvas.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, canvasWidth, canvasHeight);
        g.setColor(Color.RED);
        for (City city : travelingSalesmanTour.getCityList()) {
            int x = this.translateCoordinate(srcMinimumX, srcWidth, width, city.getX());
            int y = this.translateCoordinate(srcMinimumY, srcHeight, height, city.getY());
            g.fillRect(x - 1, y - 1, 3, 3);
        }
        g.setColor(Color.BLACK);
        if (travelingSalesmanTour.isInitialized()) {
            for (CityAssignment cityAssignment : travelingSalesmanTour.getCityAssignmentList()) {
                City city = cityAssignment.getCity();
                int x1 = this.translateCoordinate(srcMinimumX, srcWidth, width, city.getX());
                int y1 = this.translateCoordinate(srcMinimumY, srcHeight, height, city.getY());
                City nextCity = cityAssignment.getNextCityAssignment().getCity();
                int x2 = this.translateCoordinate(srcMinimumX, srcWidth, width, nextCity.getX());
                int y2 = this.translateCoordinate(srcMinimumY, srcHeight, height, nextCity.getY());
                g.drawLine(x1, y1, x2, y2);
            }
        }
        this.repaint();
    }

    private int translateCoordinate(double srcMinimum, double srcLength, double length, double value) {
        return (int)Math.floor((value - srcMinimum) * length / srcLength);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.canvas != null) {
            g.drawImage(this.canvas, 0, 0, this);
        }
    }
}

