/*
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.planner.examples.nurserostering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.nurserostering.domain.contract.Contract;

@XStreamAlias("RosterInfo")
public class RosterInfo extends AbstractPersistable implements Comparable<RosterInfo> {

    private ShiftDate firstShiftDate;
    private ShiftDate lastShiftDate;

    public RosterInfo(ShiftDate firstShiftDate, ShiftDate lastShiftDate) {
        this.firstShiftDate = firstShiftDate;
        this.lastShiftDate = lastShiftDate;
    }

    public ShiftDate getFirstShiftDate() {
        return firstShiftDate;
    }

    public void setFirstShiftDate(ShiftDate firstShiftDate) {
        this.firstShiftDate = firstShiftDate;
    }

    public ShiftDate getLastShiftDate() {
        return lastShiftDate;
    }

    public void setLastShiftDate(ShiftDate lastShiftDate) {
        this.lastShiftDate = lastShiftDate;
    }

    public int compareTo(RosterInfo other) {
        return new CompareToBuilder()
                .append(firstShiftDate, other.firstShiftDate)
                .append(lastShiftDate, other.lastShiftDate)
                .toComparison();
    }

    @Override
    public String toString() {
        return firstShiftDate + " - " + lastShiftDate;
    }

    public int getFirstShiftDateDayIndex() {
        return firstShiftDate.getDayIndex();
    }

    public int getLastShiftDateDayIndex() {
        return lastShiftDate.getDayIndex();
    }

}
