/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.cloudbalancing.domain.CloudAssignment;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.solver.move.CloudBalancingMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudComputerChangeMove
implements Move,
TabuPropertyEnabled {
    private CloudAssignment cloudAssignment;
    private CloudComputer toCloudComputer;

    public CloudComputerChangeMove(CloudAssignment cloudAssignment, CloudComputer toCloudComputer) {
        this.cloudAssignment = cloudAssignment;
        this.toCloudComputer = toCloudComputer;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.cloudAssignment.getCloudComputer(), (Object)this.toCloudComputer);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new CloudComputerChangeMove(this.cloudAssignment, this.cloudAssignment.getCloudComputer());
    }

    public void doMove(WorkingMemory workingMemory) {
        CloudBalancingMoveHelper.moveCloudComputer(workingMemory, this.cloudAssignment, this.toCloudComputer);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.cloudAssignment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudComputerChangeMove) {
            CloudComputerChangeMove other = (CloudComputerChangeMove)o;
            return new EqualsBuilder().append((Object)this.cloudAssignment, (Object)other.cloudAssignment).append((Object)this.toCloudComputer, (Object)other.toCloudComputer).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cloudAssignment).append((Object)this.toCloudComputer).toHashCode();
    }

    public String toString() {
        return this.cloudAssignment + " => " + this.toCloudComputer;
    }
}

