/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.solver.solution.initializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.score.DefaultHardAndSoftScore;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.nurserostering.domain.Assignment;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.NurseRoster;
import org.drools.planner.examples.nurserostering.domain.Shift;
import org.drools.planner.examples.nurserostering.domain.ShiftDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NurseRosteringStartingSolutionInitializer
implements CustomSolverPhaseCommand {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public void changeWorkingSolution(SolutionDirector solutionDirector) {
        NurseRoster nurseRoster = (NurseRoster)solutionDirector.getWorkingSolution();
        this.initializeAssignmentList(solutionDirector, nurseRoster);
    }

    private void initializeAssignmentList(SolutionDirector solutionDirector, NurseRoster nurseRoster) {
        List<Employee> employeeList = nurseRoster.getEmployeeList();
        WorkingMemory workingMemory = solutionDirector.getWorkingMemory();
        List<Assignment> assignmentList = this.createAssignmentList(nurseRoster);
        for (Assignment assignment : assignmentList) {
            FactHandle assignmentHandle = null;
            DefaultHardAndSoftScore bestScore = DefaultHardAndSoftScore.valueOf((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE);
            Employee bestEmployee = null;
            for (Employee employee : employeeList) {
                Score score;
                assignment.setEmployee(employee);
                if (assignmentHandle == null) {
                    assignmentHandle = workingMemory.insert((Object)assignment);
                } else {
                    workingMemory.update((org.drools.runtime.rule.FactHandle)assignmentHandle, (Object)assignment);
                }
                if ((score = solutionDirector.calculateScoreFromWorkingMemory()).compareTo((Object)bestScore) <= 0) continue;
                bestScore = score;
                bestEmployee = employee;
            }
            if (bestEmployee == null) {
                throw new IllegalStateException("The bestEmployee (" + bestEmployee + ") cannot be null.");
            }
            assignment.setEmployee(bestEmployee);
            workingMemory.update(assignmentHandle, (Object)assignment);
            this.logger.debug("    Assignment ({}) initialized for starting solution.", (Object)assignment);
        }
        Collections.sort(assignmentList, new PersistableIdComparator());
        nurseRoster.setAssignmentList(assignmentList);
    }

    public List<Assignment> createAssignmentList(NurseRoster nurseRoster) {
        List<Shift> shiftList = nurseRoster.getShiftList();
        List<ShiftDate> shiftDateList = nurseRoster.getShiftDateList();
        ArrayList<ShiftInitializationWeight> shiftInitializationWeightList = new ArrayList<ShiftInitializationWeight>(shiftList.size());
        for (Shift shift : shiftList) {
            shiftInitializationWeightList.add(new ShiftInitializationWeight(nurseRoster, shift));
        }
        Collections.sort(shiftInitializationWeightList);
        ArrayList<Assignment> assignmentList = new ArrayList<Assignment>(shiftDateList.size() * nurseRoster.getEmployeeList().size());
        int assignmentId = 0;
        for (ShiftInitializationWeight shiftInitializationWeight : shiftInitializationWeightList) {
            Shift shift = shiftInitializationWeight.getShift();
            for (int i = 0; i < shift.getRequiredEmployeeSize(); ++i) {
                Assignment assignment = new Assignment();
                assignment.setId(Long.valueOf(assignmentId));
                assignment.setShift(shift);
                assignmentList.add(assignment);
                ++assignmentId;
            }
        }
        return assignmentList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShiftInitializationWeight
    implements Comparable<ShiftInitializationWeight> {
        private Shift shift;

        private ShiftInitializationWeight(NurseRoster nurseRoster, Shift shift) {
            this.shift = shift;
        }

        public Shift getShift() {
            return this.shift;
        }

        @Override
        public int compareTo(ShiftInitializationWeight other) {
            return new CompareToBuilder().append((Object)this.shift.getShiftDate(), (Object)other.shift.getShiftDate()).append(other.shift.getRequiredEmployeeSize(), this.shift.getRequiredEmployeeSize()).append((Object)this.shift.getShiftType(), (Object)other.shift.getShiftType()).toComparison();
        }
    }
}

