/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.drools.planner.config.XmlSolverConfigurer;
import org.drools.planner.config.constructionheuristic.ConstructionHeuristicSolverPhaseConfig;
import org.drools.planner.config.localsearch.LocalSearchSolverPhaseConfig;
import org.drools.planner.config.score.definition.ScoreDefinitionConfig;
import org.drools.planner.config.solver.SolverConfig;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.constructionheuristic.greedyFit.decider.ConstructionHeuristicPickEarlyType;
import org.drools.planner.examples.common.app.CommonApp;
import org.drools.planner.examples.common.persistence.SolutionDao;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.nqueens.domain.NQueens;
import org.drools.planner.examples.nqueens.domain.Queen;
import org.drools.planner.examples.nqueens.persistence.NQueensDaoImpl;
import org.drools.planner.examples.nqueens.solver.move.factory.RowChangeMoveFactory;
import org.drools.planner.examples.nqueens.swingui.NQueensPanel;

public class NQueensApp
extends CommonApp {
    public static final String SOLVER_CONFIG = "/org/drools/planner/examples/nqueens/solver/nqueensSolverConfig.xml";

    public static void main(String[] args) {
        new NQueensApp().init();
    }

    protected Solver createSolver() {
        XmlSolverConfigurer configurer = new XmlSolverConfigurer();
        configurer.configure(SOLVER_CONFIG);
        return configurer.buildSolver();
    }

    protected Solver createSolverByApi() {
        SolverConfig solverConfig = new SolverConfig();
        solverConfig.setSolutionClass(NQueens.class);
        HashSet<Class<Queen>> planningEntityClassSet = new HashSet<Class<Queen>>();
        planningEntityClassSet.add(Queen.class);
        solverConfig.setPlanningEntityClassSet(planningEntityClassSet);
        solverConfig.setScoreDrlList(Arrays.asList("/org/drools/planner/examples/nqueens/solver/nQueensScoreRules.drl"));
        ScoreDefinitionConfig scoreDefinitionConfig = solverConfig.getScoreDefinitionConfig();
        scoreDefinitionConfig.setScoreDefinitionType(ScoreDefinitionConfig.ScoreDefinitionType.SIMPLE);
        TerminationConfig terminationConfig = solverConfig.getTerminationConfig();
        terminationConfig.setScoreAttained("0");
        ArrayList<Object> solverPhaseConfigList = new ArrayList<Object>();
        ConstructionHeuristicSolverPhaseConfig constructionHeuristicSolverPhaseConfig = new ConstructionHeuristicSolverPhaseConfig();
        constructionHeuristicSolverPhaseConfig.setConstructionHeuristicType(ConstructionHeuristicSolverPhaseConfig.ConstructionHeuristicType.FIRST_FIT_DECREASING);
        constructionHeuristicSolverPhaseConfig.setConstructionHeuristicPickEarlyType(ConstructionHeuristicPickEarlyType.FIRST_LAST_STEP_SCORE_EQUAL_OR_IMPROVING);
        solverPhaseConfigList.add(constructionHeuristicSolverPhaseConfig);
        LocalSearchSolverPhaseConfig localSearchSolverPhaseConfig = new LocalSearchSolverPhaseConfig();
        localSearchSolverPhaseConfig.getSelectorConfig().setMoveFactoryClass(RowChangeMoveFactory.class);
        localSearchSolverPhaseConfig.getAcceptorConfig().setCompleteSolutionTabuSize(Integer.valueOf(1000));
        solverPhaseConfigList.add(localSearchSolverPhaseConfig);
        solverConfig.setSolverPhaseConfigList(solverPhaseConfigList);
        return solverConfig.buildSolver();
    }

    protected SolutionPanel createSolutionPanel() {
        return new NQueensPanel();
    }

    protected SolutionDao createSolutionDao() {
        return new NQueensDaoImpl();
    }
}

