/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.Period;
import org.drools.planner.examples.curriculumcourse.domain.Room;
import org.drools.planner.examples.curriculumcourse.solver.move.PeriodChangeMove;
import org.drools.planner.examples.curriculumcourse.solver.move.RoomChangeMove;

public class CurriculumCoursePanel
extends SolutionPanel {
    private static final Color HEADER_COLOR = Color.YELLOW;
    private GridLayout gridLayout = new GridLayout(0, 1);

    public CurriculumCoursePanel() {
        this.setLayout(this.gridLayout);
    }

    private CurriculumCourseSchedule getCurriculumCourseSchedule() {
        return (CurriculumCourseSchedule)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        this.removeAll();
        CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)solution;
        this.gridLayout.setColumns(schedule.getRoomList().size() + 1);
        JLabel headerCornerLabel = new JLabel("Period         \\         Room");
        headerCornerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        headerCornerLabel.setBackground(HEADER_COLOR);
        headerCornerLabel.setOpaque(true);
        this.add(headerCornerLabel);
        for (Room room : schedule.getRoomList()) {
            JLabel roomLabel = new JLabel(room.toString());
            roomLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            roomLabel.setBackground(HEADER_COLOR);
            roomLabel.setOpaque(true);
            this.add(roomLabel);
        }
        HashMap periodRoomPanelMap = new HashMap();
        for (Period period : schedule.getPeriodList()) {
            JLabel periodLabel = new JLabel(period.toString());
            periodLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            periodLabel.setBackground(HEADER_COLOR);
            periodLabel.setOpaque(true);
            this.add(periodLabel);
            HashMap<Room, PeriodRoomPanel> roomPanelMap = new HashMap<Room, PeriodRoomPanel>();
            periodRoomPanelMap.put(period, roomPanelMap);
            for (Room room : schedule.getRoomList()) {
                PeriodRoomPanel periodRoomPanel = new PeriodRoomPanel();
                this.add(periodRoomPanel);
                roomPanelMap.put(room, periodRoomPanel);
            }
        }
        for (Lecture lecture : schedule.getLectureList()) {
            Period period = lecture.getPeriod();
            Room room = lecture.getRoom();
            if (period == null || room == null) continue;
            PeriodRoomPanel periodRoomPanel = (PeriodRoomPanel)((Map)periodRoomPanelMap.get(period)).get(room);
            periodRoomPanel.addLecture(lecture);
        }
    }

    private class ExamAction
    extends AbstractAction {
        private Lecture lecture;

        public ExamAction(Lecture lecture) {
            super(lecture.getLabel());
            this.lecture = lecture;
        }

        public void actionPerformed(ActionEvent e) {
            JPanel listFieldsPanel = new JPanel(new GridLayout(2, 1));
            List<Period> periodList = CurriculumCoursePanel.this.getCurriculumCourseSchedule().getPeriodList();
            JComboBox<Object> periodListField = new JComboBox<Object>(periodList.toArray());
            periodListField.setSelectedItem(this.lecture.getPeriod());
            listFieldsPanel.add(periodListField);
            List<Room> roomList = CurriculumCoursePanel.this.getCurriculumCourseSchedule().getRoomList();
            JComboBox<Object> roomListField = new JComboBox<Object>(roomList.toArray());
            roomListField.setSelectedItem(this.lecture.getRoom());
            listFieldsPanel.add(roomListField);
            int result = JOptionPane.showConfirmDialog(CurriculumCoursePanel.this.getRootPane(), listFieldsPanel, "Select period and room", 2);
            if (result == 0) {
                Period toPeriod = (Period)periodListField.getSelectedItem();
                CurriculumCoursePanel.this.solutionBusiness.doMove(new PeriodChangeMove(this.lecture, toPeriod));
                Room toRoom = (Room)roomListField.getSelectedItem();
                CurriculumCoursePanel.this.solutionBusiness.doMove(new RoomChangeMove(this.lecture, toRoom));
                CurriculumCoursePanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }

    private class PeriodRoomPanel
    extends JPanel {
        public PeriodRoomPanel() {
            super(new GridLayout(0, 1));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        public void addLecture(Lecture lecture) {
            JButton button = new JButton(new ExamAction(lecture));
            this.add(button);
        }
    }
}

