/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.manners2009.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionImporter;
import org.drools.planner.examples.manners2009.domain.Gender;
import org.drools.planner.examples.manners2009.domain.Guest;
import org.drools.planner.examples.manners2009.domain.Hobby;
import org.drools.planner.examples.manners2009.domain.HobbyPractician;
import org.drools.planner.examples.manners2009.domain.Job;
import org.drools.planner.examples.manners2009.domain.JobType;
import org.drools.planner.examples.manners2009.domain.Manners2009;
import org.drools.planner.examples.manners2009.domain.Seat;
import org.drools.planner.examples.manners2009.domain.SeatDesignation;
import org.drools.planner.examples.manners2009.domain.Table;
import org.drools.planner.examples.manners2009.persistence.Manners2009DaoImpl;

public class Manners2009SolutionImporter
extends AbstractTxtSolutionImporter {
    public static void main(String[] args) {
        new Manners2009SolutionImporter().convertAll();
    }

    public Manners2009SolutionImporter() {
        super(new Manners2009DaoImpl());
    }

    public AbstractTxtSolutionImporter.TxtInputBuilder createTxtInputBuilder() {
        return new Manners2009InputBuilder();
    }

    public class Manners2009InputBuilder
    extends AbstractTxtSolutionImporter.TxtInputBuilder {
        public Manners2009InputBuilder() {
            super(Manners2009SolutionImporter.this);
        }

        public Solution readSolution() throws IOException {
            Manners2009 manners2009 = new Manners2009();
            manners2009.setId(0L);
            this.readTableListAndSeatList(manners2009);
            this.readJobListGuestListAndHobbyPracticianList(manners2009);
            this.createSeatDesignationList(manners2009);
            Manners2009SolutionImporter.this.logger.info("Manners2009 with {} jobs, {} guests, {} hobby practicians, {} tables and {} seats.", new Object[]{manners2009.getJobList().size(), manners2009.getGuestList().size(), manners2009.getHobbyPracticianList().size(), manners2009.getTableList().size(), manners2009.getSeatList().size()});
            return manners2009;
        }

        private void readTableListAndSeatList(Manners2009 manners2009) throws IOException {
            int tableListSize = this.readIntegerValue("Tables:");
            int seatsPerTable = this.readIntegerValue("SeatsPerTable:");
            ArrayList<Table> tableList = new ArrayList<Table>(tableListSize);
            ArrayList<Seat> seatList = new ArrayList<Seat>(tableListSize * seatsPerTable);
            for (int i = 0; i < tableListSize; ++i) {
                Table table = new Table();
                table.setId(Long.valueOf(i));
                table.setTableIndex(i);
                ArrayList<Seat> tableSeatList = new ArrayList<Seat>(seatsPerTable);
                Seat firstSeat = null;
                Seat previousSeat = null;
                for (int j = 0; j < seatsPerTable; ++j) {
                    Seat seat = new Seat();
                    seat.setId(Long.valueOf(i * seatsPerTable + j));
                    seat.setTable(table);
                    seat.setSeatIndexInTable(j);
                    if (previousSeat != null) {
                        seat.setLeftSeat(previousSeat);
                        previousSeat.setRightSeat(seat);
                    } else {
                        firstSeat = seat;
                    }
                    tableSeatList.add(seat);
                    seatList.add(seat);
                    previousSeat = seat;
                }
                firstSeat.setLeftSeat(previousSeat);
                previousSeat.setRightSeat(firstSeat);
                table.setSeatList(tableSeatList);
                tableList.add(table);
            }
            manners2009.setTableList(tableList);
            manners2009.setSeatList(seatList);
        }

        private void readJobListGuestListAndHobbyPracticianList(Manners2009 manners2009) throws IOException {
            this.readConstantLine("Num,Profession,SubProf,Gender,Spt1,Spt2,Spt3");
            this.readConstantLine("-------------------------------------------");
            int guestSize = manners2009.getSeatList().size();
            ArrayList<Guest> guestList = new ArrayList<Guest>(guestSize);
            ArrayList<HobbyPractician> hobbyPracticianList = new ArrayList<HobbyPractician>(guestSize * 3);
            HashMap<String, Job> jobMap = new HashMap<String, Job>(JobType.values().length * 5);
            int jobNextId = 0;
            int hobbyPracticianJobId = 0;
            for (int i = 0; i < guestSize; ++i) {
                Guest guest = new Guest();
                guest.setId(Long.valueOf(i));
                String line = this.bufferedReader.readLine();
                String[] lineTokens = line.split("\\,");
                if (lineTokens.length < 5) {
                    throw new IllegalArgumentException("Read line (" + line + ") is expected to contain at least 5 tokens.");
                }
                guest.setCode(lineTokens[0].trim());
                JobType jobType = JobType.valueOfCode(lineTokens[1].trim());
                String jobName = lineTokens[2].trim();
                String jobMapKey = (Object)((Object)jobType) + "/" + jobName;
                Job job = (Job)jobMap.get(jobMapKey);
                if (job == null) {
                    job = new Job();
                    job.setId(Long.valueOf(jobNextId));
                    ++jobNextId;
                    job.setJobType(jobType);
                    job.setName(jobName);
                    jobMap.put(jobMapKey, job);
                }
                guest.setJob(job);
                guest.setGender(Gender.valueOfCode(lineTokens[3].trim()));
                ArrayList<HobbyPractician> hobbyPracticianOfGuestList = new ArrayList<HobbyPractician>(lineTokens.length - 4);
                for (int j = 4; j < lineTokens.length; ++j) {
                    HobbyPractician hobbyPractician = new HobbyPractician();
                    hobbyPractician.setId(Long.valueOf(hobbyPracticianJobId));
                    ++hobbyPracticianJobId;
                    hobbyPractician.setGuest(guest);
                    hobbyPractician.setHobby(Hobby.valueOfCode(lineTokens[j].trim()));
                    hobbyPracticianOfGuestList.add(hobbyPractician);
                    hobbyPracticianList.add(hobbyPractician);
                }
                guest.setHobbyPracticianList(hobbyPracticianOfGuestList);
                guestList.add(guest);
            }
            manners2009.setJobList(new ArrayList<Job>(jobMap.values()));
            manners2009.setGuestList(guestList);
            manners2009.setHobbyPracticianList(hobbyPracticianList);
        }

        private void createSeatDesignationList(Manners2009 manners2009) {
            List<Guest> guestList = manners2009.getGuestList();
            ArrayList<SeatDesignation> seatDesignationList = new ArrayList<SeatDesignation>(guestList.size());
            long id = 0L;
            for (Guest guest : guestList) {
                SeatDesignation seatDesignation = new SeatDesignation();
                seatDesignation.setId(id);
                ++id;
                seatDesignation.setGuest(guest);
                seatDesignationList.add(seatDesignation);
            }
            manners2009.setSeatDesignationList(seatDesignationList);
        }
    }
}

