/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.domain.solution;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.api.domain.entity.PlanningEntityDifficultyWeightFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.nqueens.domain.NQueens;
import org.drools.planner.examples.nqueens.domain.Queen;

public class QueenDifficultyWeightFactory
implements PlanningEntityDifficultyWeightFactory {
    public Comparable createDifficultyWeight(Solution solution, Object planningEntity) {
        NQueens nQueens = (NQueens)solution;
        Queen queen = (Queen)planningEntity;
        int distanceFromMiddle = QueenDifficultyWeightFactory.calculateDistanceFromMiddle(nQueens.getN(), queen.getColumnIndex());
        return new QueenDifficultyWeight(queen, distanceFromMiddle);
    }

    private static int calculateDistanceFromMiddle(int n, int columnIndex) {
        int middle = n / 2;
        int distanceFromMiddle = Math.abs(columnIndex - middle);
        if (n % 2 == 0 && columnIndex < middle) {
            --distanceFromMiddle;
        }
        return distanceFromMiddle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueenDifficultyWeight
    implements Comparable<QueenDifficultyWeight> {
        private final Queen queen;
        private final int distanceFromMiddle;

        public QueenDifficultyWeight(Queen queen, int distanceFromMiddle) {
            this.queen = queen;
            this.distanceFromMiddle = distanceFromMiddle;
        }

        @Override
        public int compareTo(QueenDifficultyWeight other) {
            return new CompareToBuilder().append(other.distanceFromMiddle, this.distanceFromMiddle).append(this.queen.getColumnIndex(), other.queen.getColumnIndex()).toComparison();
        }
    }
}

