/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.swingui;

import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.drools.planner.examples.common.business.ScoreDetail;
import org.drools.planner.examples.common.business.SolutionBusiness;
import org.drools.planner.examples.common.swingui.SolverAndPersistenceFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintScoreMapDialog
extends JDialog {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverAndPersistenceFrame solverAndPersistenceFrame;
    protected SolutionBusiness solutionBusiness;

    public ConstraintScoreMapDialog(SolverAndPersistenceFrame solverAndPersistenceFrame) {
        super(solverAndPersistenceFrame, "Constraint scores", true);
        this.solverAndPersistenceFrame = solverAndPersistenceFrame;
    }

    public void setSolutionBusiness(SolutionBusiness solutionBusiness) {
        this.solutionBusiness = solutionBusiness;
    }

    public void resetContentPanel() {
        final List<ScoreDetail> scoreDetailList = this.solutionBusiness.getScoreDetailList();
        JSplitPane splitPane = new JSplitPane(0);
        final JTable table = new JTable(new ScoreDetailTableModel(scoreDetailList));
        JScrollPane tableScrollPane = new JScrollPane(table);
        tableScrollPane.setPreferredSize(new Dimension(700, 300));
        splitPane.setTopComponent(tableScrollPane);
        final JTextArea detailTextArea = new JTextArea(10, 80);
        JScrollPane detailScrollPane = new JScrollPane(detailTextArea);
        splitPane.setBottomComponent(detailScrollPane);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                int selectedRow = table.getSelectedRow();
                if (selectedRow < 0) {
                    detailTextArea.setText("");
                } else {
                    ScoreDetail scoreDetail = (ScoreDetail)scoreDetailList.get(selectedRow);
                    detailTextArea.setText(scoreDetail.buildConstraintOccurrenceListText());
                }
            }
        });
        splitPane.setResizeWeight(1.0);
        this.setContentPane(splitPane);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private static class ShowButtonTableRenderer
    implements TableCellRenderer {
        private ShowButtonTableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (JButton)value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScoreDetailTableModel
    extends AbstractTableModel {
        private List<ScoreDetail> scoreDetailList;

        public ScoreDetailTableModel(List<ScoreDetail> scoreDetailList) {
            this.scoreDetailList = scoreDetailList;
        }

        @Override
        public int getRowCount() {
            return this.scoreDetailList.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Rule id";
                }
                case 1: {
                    return "Constraint type";
                }
                case 2: {
                    return "# occurrences";
                }
                case 3: {
                    return "Score total";
                }
            }
            throw new IllegalStateException("The columnIndex (" + columnIndex + ") is invalid.");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Enum.class;
                }
                case 2: {
                    return Integer.class;
                }
                case 3: {
                    return Double.class;
                }
            }
            throw new IllegalStateException("The columnIndex (" + columnIndex + ") is invalid.");
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ScoreDetail scoreDetail = this.scoreDetailList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return scoreDetail.getRuleId();
                }
                case 1: {
                    return scoreDetail.getConstraintType();
                }
                case 2: {
                    return scoreDetail.getOccurrenceSize();
                }
                case 3: {
                    return scoreDetail.getScoreTotal();
                }
            }
            throw new IllegalStateException("The columnIndex (" + columnIndex + ") is invalid.");
        }
    }
}

