/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.nurserostering.domain.DayOfWeek;
import org.drools.planner.examples.nurserostering.domain.Shift;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="ShiftDate")
public class ShiftDate
extends AbstractPersistable
implements Comparable<ShiftDate> {
    private int dayIndex;
    private String dateString;
    private DayOfWeek dayOfWeek;
    private List<Shift> shiftList;

    public int getDayIndex() {
        return this.dayIndex;
    }

    public void setDayIndex(int dayIndex) {
        this.dayIndex = dayIndex;
    }

    public String getDateString() {
        return this.dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeek dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public List<Shift> getShiftList() {
        return this.shiftList;
    }

    public void setShiftList(List<Shift> shiftList) {
        this.shiftList = shiftList;
    }

    public String getLabel() {
        return this.dateString.substring(5);
    }

    @Override
    public int compareTo(ShiftDate other) {
        return new CompareToBuilder().append(this.dayIndex, other.dayIndex).toComparison();
    }

    @Override
    public String toString() {
        return this.dateString + "(" + (Object)((Object)this.dayOfWeek) + ")";
    }

    public int getWeekendSundayIndex() {
        switch (this.dayOfWeek) {
            case MONDAY: {
                return this.dayIndex - 1;
            }
            case TUESDAY: {
                return this.dayIndex - 2;
            }
            case WEDNESDAY: {
                return this.dayIndex - 3;
            }
            case THURSDAY: {
                return this.dayIndex + 3;
            }
            case FRIDAY: {
                return this.dayIndex + 2;
            }
            case SATURDAY: {
                return this.dayIndex + 1;
            }
            case SUNDAY: {
                return this.dayIndex;
            }
        }
        throw new IllegalArgumentException("The dayOfWeek (" + (Object)((Object)this.dayOfWeek) + ") is not valid.");
    }
}

