/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRangeFromSolutionProperty;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.tsp.domain.City;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PlanningEntity
@XStreamAlias(value="CityAssignment")
public class CityAssignment
extends AbstractPersistable
implements Comparable<CityAssignment> {
    private City city;
    private CityAssignment previousCityAssignment;
    private CityAssignment nextCityAssignment;

    public City getCity() {
        return this.city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    @PlanningVariable
    @ValueRangeFromSolutionProperty(propertyName="cityAssignmentList")
    public CityAssignment getPreviousCityAssignment() {
        return this.previousCityAssignment;
    }

    public void setPreviousCityAssignment(CityAssignment previousCityAssignment) {
        this.previousCityAssignment = previousCityAssignment;
    }

    @PlanningVariable
    @ValueRangeFromSolutionProperty(propertyName="cityAssignmentList")
    public CityAssignment getNextCityAssignment() {
        return this.nextCityAssignment;
    }

    public void setNextCityAssignment(CityAssignment nextCityAssignment) {
        this.nextCityAssignment = nextCityAssignment;
    }

    @Override
    public int compareTo(CityAssignment other) {
        return new CompareToBuilder().append((Object)this.city, (Object)other.city).append((Object)this.id, (Object)other.id).toComparison();
    }

    public CityAssignment clone() {
        CityAssignment clone = new CityAssignment();
        clone.id = this.id;
        clone.city = this.city;
        clone.previousCityAssignment = this.previousCityAssignment;
        clone.nextCityAssignment = this.nextCityAssignment;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CityAssignment) {
            CityAssignment other = (CityAssignment)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.city, (Object)other.city).append((Object)this.previousCityAssignment, (Object)other.previousCityAssignment).append((Object)this.nextCityAssignment, (Object)other.nextCityAssignment).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.city).append((Object)this.previousCityAssignment).append((Object)this.nextCityAssignment).toHashCode();
    }

    @Override
    public String toString() {
        return this.city.toString();
    }

    public int getDistanceToNextCityAssignment() {
        return this.city.getDistance(this.nextCityAssignment.getCity());
    }
}

