/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.common.domain.AbstractPersistable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="CloudBalance")
public class CloudBalance
extends AbstractPersistable
implements Solution<HardAndSoftScore> {
    private List<CloudComputer> cloudComputerList;
    private List<CloudProcess> cloudProcessList;
    private HardAndSoftScore score;

    public List<CloudComputer> getCloudComputerList() {
        return this.cloudComputerList;
    }

    public void setCloudComputerList(List<CloudComputer> cloudComputerList) {
        this.cloudComputerList = cloudComputerList;
    }

    @PlanningEntityCollectionProperty
    public List<CloudProcess> getCloudProcessList() {
        return this.cloudProcessList;
    }

    public void setCloudProcessList(List<CloudProcess> cloudProcessList) {
        this.cloudProcessList = cloudProcessList;
    }

    public HardAndSoftScore getScore() {
        return this.score;
    }

    public void setScore(HardAndSoftScore score) {
        this.score = score;
    }

    public Collection<? extends Object> getProblemFacts() {
        ArrayList<CloudComputer> facts = new ArrayList<CloudComputer>();
        facts.addAll(this.cloudComputerList);
        return facts;
    }

    public CloudBalance cloneSolution() {
        CloudBalance clone = new CloudBalance();
        clone.id = this.id;
        clone.cloudComputerList = this.cloudComputerList;
        ArrayList<CloudProcess> clonedCloudProcessList = new ArrayList<CloudProcess>(this.cloudProcessList.size());
        for (CloudProcess cloudProcess : this.cloudProcessList) {
            CloudProcess clonedCloudProcess = cloudProcess.clone();
            clonedCloudProcessList.add(clonedCloudProcess);
        }
        clone.cloudProcessList = clonedCloudProcessList;
        clone.score = this.score;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.id == null || !(o instanceof CloudBalance)) {
            return false;
        }
        CloudBalance other = (CloudBalance)o;
        if (this.cloudProcessList.size() != other.cloudProcessList.size()) {
            return false;
        }
        Iterator<CloudProcess> it = this.cloudProcessList.iterator();
        Iterator<CloudProcess> otherIt = other.cloudProcessList.iterator();
        while (it.hasNext()) {
            CloudProcess otherCloudProcess;
            CloudProcess cloudProcess = it.next();
            if (cloudProcess.solutionEquals(otherCloudProcess = otherIt.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        for (CloudProcess cloudProcess : this.cloudProcessList) {
            hashCodeBuilder.append(cloudProcess.solutionHashCode());
        }
        return hashCodeBuilder.toHashCode();
    }
}

