/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.lang.ObjectUtils;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solution.director.SolutionDirector;
import org.drools.planner.core.solver.ProblemFactChange;
import org.drools.planner.examples.cloudbalancing.domain.CloudBalance;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.solver.move.CloudComputerChangeMove;
import org.drools.planner.examples.cloudbalancing.swingui.CloudComputerPanel;
import org.drools.planner.examples.common.swingui.SolutionPanel;

public class CloudBalancingPanel
extends SolutionPanel {
    public static final Color[] PROCESS_COLORS = new Color[]{Color.GREEN, Color.YELLOW, Color.BLUE, Color.RED, Color.CYAN, Color.ORANGE, Color.MAGENTA};
    private JPanel computersPanel;
    private CloudComputerPanel unassignedPanel;
    private Map<CloudComputer, CloudComputerPanel> cloudComputerToPanelMap;
    private Map<CloudProcess, CloudComputerPanel> cloudProcessToPanelMap;

    public CloudBalancingPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JPanel headerPanel = this.createHeaderPanel();
        JPanel computersPanel = this.createComputersPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(computersPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(computersPanel, -2, -2, -2));
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new GridLayout(0, 5));
        JLabel emptyLabel = new JLabel("");
        headerPanel.add(emptyLabel);
        JLabel cpuPowerLabel = new JLabel("CPU power");
        headerPanel.add(cpuPowerLabel);
        JLabel memoryLabel = new JLabel("Memory");
        headerPanel.add(memoryLabel);
        JLabel networkBandwidthLabel = new JLabel("Network bandwidth");
        headerPanel.add(networkBandwidthLabel);
        JLabel costLabel = new JLabel("Cost");
        headerPanel.add(costLabel);
        return headerPanel;
    }

    private JPanel createComputersPanel() {
        this.computersPanel = new JPanel(new GridLayout(0, 1));
        this.unassignedPanel = new CloudComputerPanel(this, null);
        this.computersPanel.add(this.unassignedPanel);
        this.cloudComputerToPanelMap = new LinkedHashMap<CloudComputer, CloudComputerPanel>();
        this.cloudComputerToPanelMap.put(null, this.unassignedPanel);
        this.cloudProcessToPanelMap = new LinkedHashMap<CloudProcess, CloudComputerPanel>();
        return this.computersPanel;
    }

    private CloudBalance getCloudBalance() {
        return (CloudBalance)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        for (CloudComputerPanel cloudComputerCloudComputerPanel : this.cloudComputerToPanelMap.values()) {
            if (cloudComputerCloudComputerPanel.getCloudComputer() == null) continue;
            this.computersPanel.remove(cloudComputerCloudComputerPanel);
        }
        this.cloudComputerToPanelMap.clear();
        this.cloudComputerToPanelMap.put(null, this.unassignedPanel);
        this.cloudProcessToPanelMap.clear();
        this.unassignedPanel.clearCloudProcesss();
        this.updatePanel(solution);
    }

    public void updatePanel(Solution solution) {
        CloudComputerPanel deadCloudComputerPanel;
        CloudBalance cloudBalance = (CloudBalance)solution;
        LinkedHashSet<CloudComputer> deadCloudComputerSet = new LinkedHashSet<CloudComputer>(this.cloudComputerToPanelMap.keySet());
        deadCloudComputerSet.remove(null);
        for (CloudComputer cloudComputer : cloudBalance.getCloudComputerList()) {
            deadCloudComputerSet.remove(cloudComputer);
            CloudComputerPanel cloudComputerPanel = this.cloudComputerToPanelMap.get(cloudComputer);
            if (cloudComputerPanel != null) continue;
            cloudComputerPanel = new CloudComputerPanel(this, cloudComputer);
            this.computersPanel.add(cloudComputerPanel);
            this.cloudComputerToPanelMap.put(cloudComputer, cloudComputerPanel);
        }
        LinkedHashSet<CloudProcess> deadCloudProcessSet = new LinkedHashSet<CloudProcess>(this.cloudProcessToPanelMap.keySet());
        for (CloudProcess cloudProcess : cloudBalance.getCloudProcessList()) {
            deadCloudProcessSet.remove(cloudProcess);
            CloudComputerPanel cloudComputerPanel = this.cloudProcessToPanelMap.get(cloudProcess);
            CloudComputer cloudComputer = cloudProcess.getCloudComputer();
            if (cloudComputerPanel != null && !ObjectUtils.equals((Object)cloudComputerPanel.getCloudComputer(), (Object)cloudComputer)) {
                this.cloudProcessToPanelMap.remove(cloudProcess);
                cloudComputerPanel.removeCloudProcess(cloudProcess);
                cloudComputerPanel = null;
            }
            if (cloudComputerPanel != null) continue;
            cloudComputerPanel = this.cloudComputerToPanelMap.get(cloudComputer);
            cloudComputerPanel.addCloudProcess(cloudProcess);
            this.cloudProcessToPanelMap.put(cloudProcess, cloudComputerPanel);
        }
        for (CloudProcess deadCloudProcess : deadCloudProcessSet) {
            deadCloudComputerPanel = this.cloudProcessToPanelMap.remove(deadCloudProcess);
            deadCloudComputerPanel.removeCloudProcess(deadCloudProcess);
        }
        for (CloudComputer deadCloudComputer : deadCloudComputerSet) {
            deadCloudComputerPanel = this.cloudComputerToPanelMap.remove(deadCloudComputer);
            this.computersPanel.remove(deadCloudComputerPanel);
        }
        for (CloudComputerPanel cloudComputerPanel : this.cloudComputerToPanelMap.values()) {
            cloudComputerPanel.update();
        }
    }

    public void deleteComputer(final CloudComputer cloudComputer) {
        this.logger.info("Scheduling deleting of computer ({}).", (Object)cloudComputer.getLabel());
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            public void doChange(SolutionDirector solutionDirector) {
                CloudBalance cloudBalance = (CloudBalance)solutionDirector.getWorkingSolution();
                WorkingMemory workingMemory = solutionDirector.getWorkingMemory();
                for (CloudProcess cloudProcess : cloudBalance.getCloudProcessList()) {
                    if (!ObjectUtils.equals((Object)cloudProcess.getCloudComputer(), (Object)cloudComputer)) continue;
                    FactHandle cloudProcessHandle = workingMemory.getFactHandle((Object)cloudProcess);
                    cloudProcess.setCloudComputer(null);
                    workingMemory.retract((org.drools.runtime.rule.FactHandle)cloudProcessHandle);
                }
                Iterator<CloudComputer> it = cloudBalance.getCloudComputerList().iterator();
                while (it.hasNext()) {
                    CloudComputer workingCloudComputer = it.next();
                    if (!ObjectUtils.equals((Object)workingCloudComputer, (Object)cloudComputer)) continue;
                    FactHandle cloudComputerHandle = workingMemory.getFactHandle((Object)workingCloudComputer);
                    workingMemory.retract((org.drools.runtime.rule.FactHandle)cloudComputerHandle);
                    it.remove();
                    break;
                }
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }

    private class CloudProcessAction
    extends AbstractAction {
        private CloudProcess cloudProcess;

        public CloudProcessAction(CloudProcess cloudProcess) {
            super("=>");
            this.cloudProcess = cloudProcess;
        }

        public void actionPerformed(ActionEvent e) {
            List<CloudComputer> cloudComputerList = CloudBalancingPanel.this.getCloudBalance().getCloudComputerList();
            JComboBox<Object> cloudComputerListField = new JComboBox<Object>(cloudComputerList.toArray());
            cloudComputerListField.setSelectedItem(this.cloudProcess.getCloudComputer());
            int result = JOptionPane.showConfirmDialog(CloudBalancingPanel.this.getRootPane(), cloudComputerListField, "Select cloud computer", 2);
            if (result == 0) {
                CloudComputer toCloudComputer = (CloudComputer)cloudComputerListField.getSelectedItem();
                CloudBalancingPanel.this.solutionBusiness.doMove(new CloudComputerChangeMove(this.cloudProcess, toCloudComputer));
                CloudBalancingPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

