/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.domain.solver;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.api.domain.entity.PlanningEntityDifficultyWeightFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.curriculumcourse.domain.Course;
import org.drools.planner.examples.curriculumcourse.domain.CurriculumCourseSchedule;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.UnavailablePeriodConstraint;

public class LectureDifficultyWeightFactory
implements PlanningEntityDifficultyWeightFactory {
    public Comparable createDifficultyWeight(Solution solution, Object planningEntity) {
        CurriculumCourseSchedule schedule = (CurriculumCourseSchedule)solution;
        Lecture lecture = (Lecture)planningEntity;
        Course course = lecture.getCourse();
        int unavailablePeriodConstraintCount = 0;
        for (UnavailablePeriodConstraint constraint : schedule.getUnavailablePeriodConstraintList()) {
            if (!constraint.getCourse().equals(course)) continue;
            ++unavailablePeriodConstraintCount;
        }
        return new LectureDifficultyWeight(lecture, unavailablePeriodConstraintCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LectureDifficultyWeight
    implements Comparable<LectureDifficultyWeight> {
        private final Lecture lecture;
        private final int unavailablePeriodConstraintCount;

        public LectureDifficultyWeight(Lecture lecture, int unavailablePeriodConstraintCount) {
            this.lecture = lecture;
            this.unavailablePeriodConstraintCount = unavailablePeriodConstraintCount;
        }

        @Override
        public int compareTo(LectureDifficultyWeight other) {
            Course course = this.lecture.getCourse();
            Course otherCourse = other.lecture.getCourse();
            return new CompareToBuilder().append(course.getCurriculumList().size(), otherCourse.getCurriculumList().size()).append(this.unavailablePeriodConstraintCount, other.unavailablePeriodConstraintCount).append(course.getLectureSize(), otherCourse.getLectureSize()).append(course.getStudentSize(), otherCourse.getStudentSize()).append(course.getMinWorkingDaySize(), otherCourse.getMinWorkingDaySize()).append((Object)this.lecture.getId(), (Object)other.lecture.getId()).toComparison();
        }
    }
}

