/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.Period;
import org.drools.planner.examples.curriculumcourse.domain.Room;
import org.drools.planner.examples.curriculumcourse.solver.move.CurriculumCourseMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LectureSwitchMove
implements Move,
TabuPropertyEnabled {
    private Lecture leftLecture;
    private Lecture rightLecture;

    public LectureSwitchMove(Lecture leftLecture, Lecture rightLecture) {
        this.leftLecture = leftLecture;
        this.rightLecture = rightLecture;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.leftLecture.getPeriod(), (Object)this.rightLecture.getPeriod()) || !ObjectUtils.equals((Object)this.leftLecture.getRoom(), (Object)this.rightLecture.getRoom());
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new LectureSwitchMove(this.rightLecture, this.leftLecture);
    }

    public void doMove(WorkingMemory workingMemory) {
        Period oldLeftPeriod = this.leftLecture.getPeriod();
        Period oldRightPeriod = this.rightLecture.getPeriod();
        Room oldLeftRoom = this.leftLecture.getRoom();
        Room oldRightRoom = this.rightLecture.getRoom();
        if (oldLeftPeriod.equals(oldRightPeriod)) {
            CurriculumCourseMoveHelper.moveRoom(workingMemory, this.leftLecture, oldRightRoom);
            CurriculumCourseMoveHelper.moveRoom(workingMemory, this.rightLecture, oldLeftRoom);
        } else if (oldLeftRoom.equals(oldRightRoom)) {
            CurriculumCourseMoveHelper.movePeriod(workingMemory, this.leftLecture, oldRightPeriod);
            CurriculumCourseMoveHelper.movePeriod(workingMemory, this.rightLecture, oldLeftPeriod);
        } else {
            CurriculumCourseMoveHelper.moveLecture(workingMemory, this.leftLecture, oldRightPeriod, oldRightRoom);
            CurriculumCourseMoveHelper.moveLecture(workingMemory, this.rightLecture, oldLeftPeriod, oldLeftRoom);
        }
    }

    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.leftLecture, this.rightLecture);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LectureSwitchMove) {
            LectureSwitchMove other = (LectureSwitchMove)o;
            return new EqualsBuilder().append((Object)this.leftLecture, (Object)other.leftLecture).append((Object)this.rightLecture, (Object)other.rightLecture).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftLecture).append((Object)this.rightLecture).toHashCode();
    }

    public String toString() {
        return this.leftLecture + " <=> " + this.rightLecture;
    }
}

