/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRangeFromSolutionProperty;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.examination.domain.Period;
import org.drools.planner.examples.examination.domain.Room;
import org.drools.planner.examples.examination.domain.Topic;
import org.drools.planner.examples.examination.domain.solver.ExamBefore;
import org.drools.planner.examples.examination.domain.solver.ExamCoincidence;

@PlanningEntity
@XStreamAlias(value="Exam")
public class Exam
extends AbstractPersistable {
    private Topic topic;
    private ExamCoincidence examCoincidence = null;
    private ExamBefore examBefore = null;
    private Period period;
    private Room room;

    public Topic getTopic() {
        return this.topic;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public ExamCoincidence getExamCoincidence() {
        return this.examCoincidence;
    }

    public void setExamCoincidence(ExamCoincidence examCoincidence) {
        this.examCoincidence = examCoincidence;
    }

    public ExamBefore getExamBefore() {
        return this.examBefore;
    }

    public void setExamBefore(ExamBefore examBefore) {
        this.examBefore = examBefore;
    }

    @PlanningVariable
    @ValueRangeFromSolutionProperty(propertyName="periodList")
    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    @PlanningVariable
    @ValueRangeFromSolutionProperty(propertyName="roomList")
    public Room getRoom() {
        return this.room;
    }

    public void setRoom(Room room) {
        this.room = room;
    }

    public boolean isCoincidenceLeader() {
        return this.examCoincidence == null || this.examCoincidence.getFirstExam() == this;
    }

    public Exam clone() {
        Exam clone = new Exam();
        clone.id = this.id;
        clone.topic = this.topic;
        clone.period = this.period;
        clone.room = this.room;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Exam) {
            Exam other = (Exam)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.topic, (Object)other.topic).append((Object)this.period, (Object)other.period).append((Object)this.room, (Object)other.room).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.topic).append((Object)this.period).append((Object)this.room).toHashCode();
    }

    public String toString() {
        return this.topic + " @ " + this.period + " + " + this.room;
    }

    public int getTopicDuration() {
        return this.getTopic().getDuration();
    }

    public int getTopicStudentSize() {
        return this.getTopic().getStudentSize();
    }

    public int getPeriodDuration() {
        return this.getPeriod().getDuration();
    }
}

