/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.traindesign.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRangeFromPlanningEntityProperty;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.traindesign.domain.CarBlock;
import org.drools.planner.examples.traindesign.domain.solver.RailPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PlanningEntity
@XStreamAlias(value="CarBlockDesignation")
public class CarBlockDesignation
extends AbstractPersistable {
    private CarBlock carBlock;
    private RailPath railPath;

    public CarBlock getCarBlock() {
        return this.carBlock;
    }

    public void setCarBlock(CarBlock carBlock) {
        this.carBlock = carBlock;
    }

    @PlanningVariable
    @ValueRangeFromPlanningEntityProperty(propertyName="possibleRailPathList")
    public RailPath getRailPath() {
        return this.railPath;
    }

    public void setRailPath(RailPath railPath) {
        this.railPath = railPath;
    }

    public CarBlockDesignation clone() {
        CarBlockDesignation clone = new CarBlockDesignation();
        clone.id = this.id;
        clone.carBlock = this.carBlock;
        clone.railPath = this.railPath;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CarBlockDesignation) {
            CarBlockDesignation other = (CarBlockDesignation)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.carBlock, (Object)other.carBlock).append((Object)this.railPath, (Object)other.railPath).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.carBlock).append((Object)this.railPath).toHashCode();
    }

    @Override
    public String toString() {
        return this.carBlock + " @ " + this.railPath;
    }

    public List<RailPath> getPossibleRailPathList() {
        return this.carBlock.getOrigin().getShortestPathTo(this.carBlock.getDestination()).getRailPathList();
    }

    public int calculateCarTravelCost(int carTravelCostPerDistance) {
        int carTravelCost = this.carBlock.getNumberOfCars() * this.railPath.getDistance() * carTravelCostPerDistance;
        if (carTravelCost % 1000000 != 0) {
            throw new IllegalStateException("The carTravelCost (" + carTravelCost + ") / 1000000 is not an integer.");
        }
        return carTravelCost / 1000000;
    }
}

