/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.solver.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.solver.move.CloudBalancingMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudProcessSwitchMove
implements Move,
TabuPropertyEnabled {
    private CloudProcess leftCloudProcess;
    private CloudProcess rightCloudProcess;

    public CloudProcessSwitchMove(CloudProcess leftCloudProcess, CloudProcess rightCloudProcess) {
        this.leftCloudProcess = leftCloudProcess;
        this.rightCloudProcess = rightCloudProcess;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        return !ObjectUtils.equals((Object)this.leftCloudProcess.getCloudComputer(), (Object)this.rightCloudProcess.getCloudComputer());
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new CloudProcessSwitchMove(this.rightCloudProcess, this.leftCloudProcess);
    }

    public void doMove(WorkingMemory workingMemory) {
        CloudComputer oldLeftCloudComputer = this.leftCloudProcess.getCloudComputer();
        CloudComputer oldRightCloudComputer = this.rightCloudProcess.getCloudComputer();
        CloudBalancingMoveHelper.moveCloudComputer(workingMemory, this.leftCloudProcess, oldRightCloudComputer);
        CloudBalancingMoveHelper.moveCloudComputer(workingMemory, this.rightCloudProcess, oldLeftCloudComputer);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Arrays.asList(this.leftCloudProcess, this.rightCloudProcess);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudProcessSwitchMove) {
            CloudProcessSwitchMove other = (CloudProcessSwitchMove)o;
            return new EqualsBuilder().append((Object)this.leftCloudProcess, (Object)other.leftCloudProcess).append((Object)this.rightCloudProcess, (Object)other.rightCloudProcess).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftCloudProcess).append((Object)this.rightCloudProcess).toHashCode();
    }

    public String toString() {
        return this.leftCloudProcess + " <=> " + this.rightCloudProcess;
    }
}

