/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.domain;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.api.domain.entity.PlanningEntity;
import org.drools.planner.api.domain.variable.PlanningVariable;
import org.drools.planner.api.domain.variable.ValueRangeFromSolutionProperty;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.nurserostering.domain.DayOfWeek;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.Shift;
import org.drools.planner.examples.nurserostering.domain.ShiftDate;
import org.drools.planner.examples.nurserostering.domain.ShiftType;
import org.drools.planner.examples.nurserostering.domain.WeekendDefinition;
import org.drools.planner.examples.nurserostering.domain.contract.Contract;
import org.drools.planner.examples.nurserostering.domain.solver.EmployeeStrengthComparator;
import org.drools.planner.examples.nurserostering.domain.solver.ShiftAssignmentDifficultyComparator;

@PlanningEntity(difficultyComparatorClass=ShiftAssignmentDifficultyComparator.class)
@XStreamAlias(value="ShiftAssignment")
public class ShiftAssignment
extends AbstractPersistable {
    private Shift shift;
    private Employee employee;

    public Shift getShift() {
        return this.shift;
    }

    public void setShift(Shift shift) {
        this.shift = shift;
    }

    @PlanningVariable(strengthComparatorClass=EmployeeStrengthComparator.class)
    @ValueRangeFromSolutionProperty(propertyName="employeeList")
    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public String getLabel() {
        return this.shift.getShiftType().getCode();
    }

    public ShiftAssignment clone() {
        ShiftAssignment clone = new ShiftAssignment();
        clone.id = this.id;
        clone.shift = this.shift;
        clone.employee = this.employee;
        return clone;
    }

    public boolean solutionEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ShiftAssignment) {
            ShiftAssignment other = (ShiftAssignment)o;
            return new EqualsBuilder().append((Object)this.id, (Object)other.id).append((Object)this.shift, (Object)other.shift).append((Object)this.employee, (Object)other.employee).isEquals();
        }
        return false;
    }

    public int solutionHashCode() {
        return new HashCodeBuilder().append((Object)this.id).append((Object)this.shift).append((Object)this.employee).toHashCode();
    }

    public String toString() {
        return this.shift + "->" + this.employee;
    }

    public ShiftDate getShiftDate() {
        return this.shift.getShiftDate();
    }

    public ShiftType getShiftType() {
        return this.shift.getShiftType();
    }

    public int getShiftDateDayIndex() {
        return this.shift.getShiftDate().getDayIndex();
    }

    public DayOfWeek getShiftDateDayOfWeek() {
        return this.shift.getShiftDate().getDayOfWeek();
    }

    public Contract getContract() {
        return this.employee.getContract();
    }

    public boolean isWeekend() {
        WeekendDefinition weekendDefinition = this.employee.getContract().getWeekendDefinition();
        DayOfWeek dayOfWeek = this.shift.getShiftDate().getDayOfWeek();
        return weekendDefinition.isWeekend(dayOfWeek);
    }

    public int getWeekendSundayIndex() {
        return this.shift.getShiftDate().getWeekendSundayIndex();
    }
}

