/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.WorkingMemory;
import org.drools.planner.core.localsearch.decider.acceptor.tabu.TabuPropertyEnabled;
import org.drools.planner.core.move.Move;
import org.drools.planner.examples.tsp.domain.Journey;
import org.drools.planner.examples.tsp.solver.move.TspMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubTourChangeMove
implements Move,
TabuPropertyEnabled {
    private Journey startJourney;
    private Journey endJourney;
    private Journey toAfterJourney;

    public SubTourChangeMove(Journey startJourney, Journey endJourney, Journey toAfterJourney) {
        this.startJourney = startJourney;
        this.endJourney = endJourney;
        this.toAfterJourney = toAfterJourney;
    }

    public boolean isMoveDoable(WorkingMemory workingMemory) {
        Journey nextJourney = this.startJourney;
        if (ObjectUtils.equals((Object)this.startJourney, (Object)this.toAfterJourney.getNextJourney())) {
            return false;
        }
        while (!ObjectUtils.equals((Object)nextJourney, (Object)this.endJourney)) {
            if (ObjectUtils.equals((Object)nextJourney, (Object)this.toAfterJourney)) {
                return false;
            }
            nextJourney = nextJourney.getNextJourney();
        }
        return !ObjectUtils.equals((Object)this.endJourney, (Object)this.toAfterJourney);
    }

    public Move createUndoMove(WorkingMemory workingMemory) {
        return new SubTourChangeMove(this.startJourney, this.endJourney, this.startJourney.getPreviousJourney());
    }

    public void doMove(WorkingMemory workingMemory) {
        Journey newPreviousJourney = this.toAfterJourney;
        Journey newNextJourney = newPreviousJourney.getNextJourney();
        Journey originalPreviousJourney = this.startJourney.getPreviousJourney();
        Journey originalNextJourney = this.endJourney.getNextJourney();
        TspMoveHelper.moveJourneyAfterJourney(workingMemory, newPreviousJourney, this.startJourney);
        TspMoveHelper.moveJourneyAfterJourney(workingMemory, this.endJourney, newNextJourney);
        TspMoveHelper.moveJourneyAfterJourney(workingMemory, originalPreviousJourney, originalNextJourney);
    }

    public Collection<? extends Object> getTabuProperties() {
        return Collections.singletonList(this.startJourney.getCity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubTourChangeMove) {
            SubTourChangeMove other = (SubTourChangeMove)o;
            return new EqualsBuilder().append((Object)this.startJourney, (Object)other.startJourney).append((Object)this.endJourney, (Object)other.endJourney).append((Object)this.toAfterJourney, (Object)other.toAfterJourney).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.startJourney).append((Object)this.endJourney).append((Object)this.toAfterJourney).toHashCode();
    }

    public String toString() {
        return this.startJourney + "-" + this.endJourney + " => after " + this.toAfterJourney;
    }
}

