/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.common.persistence;

import java.io.File;
import java.util.Arrays;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.app.LoggingMain;
import org.drools.planner.examples.common.persistence.SolutionDao;

public abstract class AbstractSolutionExporter
extends LoggingMain {
    private static final String DEFAULT_INPUT_FILE_SUFFIX = ".xml";
    protected SolutionDao solutionDao;

    public AbstractSolutionExporter(SolutionDao solutionDao) {
        this.solutionDao = solutionDao;
    }

    protected File getInputDir() {
        return new File(this.solutionDao.getDataDir(), "solved");
    }

    protected File getOutputDir() {
        return new File(this.solutionDao.getDataDir(), "output");
    }

    protected String getInputFileSuffix() {
        return DEFAULT_INPUT_FILE_SUFFIX;
    }

    protected abstract String getOutputFileSuffix();

    public void convertAll() {
        File inputDir = this.getInputDir();
        File outputDir = this.getOutputDir();
        outputDir.mkdirs();
        Object[] inputFiles = inputDir.listFiles();
        Arrays.sort(inputFiles);
        if (inputFiles == null) {
            throw new IllegalArgumentException("Your working dir should be drools-planner-examples and contain: " + inputDir);
        }
        for (Object inputFile : inputFiles) {
            String inputFileName = ((File)inputFile).getName();
            if (!inputFileName.endsWith(this.getInputFileSuffix())) continue;
            Solution solution = this.solutionDao.readSolution((File)inputFile);
            String outputFileName = inputFileName.substring(0, inputFileName.length() - this.getInputFileSuffix().length()) + this.getOutputFileSuffix();
            File outputFile = new File(outputDir, outputFileName);
            this.writeSolution(solution, outputFile);
        }
    }

    public abstract void writeSolution(Solution var1, File var2);
}

