/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nurserostering.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.examples.common.swingui.TangoColors;
import org.drools.planner.examples.nurserostering.domain.Employee;
import org.drools.planner.examples.nurserostering.domain.Shift;
import org.drools.planner.examples.nurserostering.domain.ShiftAssignment;
import org.drools.planner.examples.nurserostering.domain.ShiftDate;
import org.drools.planner.examples.nurserostering.domain.WeekendDefinition;
import org.drools.planner.examples.nurserostering.swingui.NurseRosteringPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmployeePanel
extends JPanel {
    public static final int WEST_HEADER_WIDTH = 150;
    public static final int EAST_HEADER_WIDTH = 130;
    private final NurseRosteringPanel nurseRosteringPanel;
    private List<ShiftDate> shiftDateList;
    private List<Shift> shiftList;
    private Employee employee;
    private JLabel employeeLabel;
    private JButton deleteButton;
    private JPanel shiftDateListPanel = null;
    private Map<ShiftDate, JPanel> shiftDatePanelMap;
    private Map<Shift, JPanel> shiftPanelMap;
    private JLabel numberOfShiftAssignmentsLabel;
    private Map<ShiftAssignment, JButton> shiftAssignmentButtonMap = new HashMap<ShiftAssignment, JButton>();

    public EmployeePanel(NurseRosteringPanel nurseRosteringPanel, List<ShiftDate> shiftDateList, List<Shift> shiftList, Employee employee) {
        super(new BorderLayout());
        this.nurseRosteringPanel = nurseRosteringPanel;
        this.shiftDateList = shiftDateList;
        this.shiftList = shiftList;
        this.employee = employee;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2), BorderFactory.createLineBorder(Color.BLACK)), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        this.createUI();
    }

    public Employee getEmployee() {
        return this.employee;
    }

    private String getEmployeeLabel() {
        return this.employee == null ? "Unassigned" : this.employee.getLabel();
    }

    public void setShiftDateListAndShiftList(List<ShiftDate> shiftDateList, List<Shift> shiftList) {
        this.shiftDateList = shiftDateList;
        this.shiftList = shiftList;
        this.resetShiftListPanel();
    }

    private void createUI() {
        JPanel labelAndDeletePanel = new JPanel(new BorderLayout());
        labelAndDeletePanel.setPreferredSize(new Dimension(150, 20));
        this.employeeLabel = new JLabel(this.getEmployeeLabel());
        this.employeeLabel.setEnabled(false);
        labelAndDeletePanel.add((Component)this.employeeLabel, "Center");
        if (this.employee != null) {
            this.deleteButton = new JButton(new AbstractAction("X"){

                public void actionPerformed(ActionEvent e) {
                    EmployeePanel.this.nurseRosteringPanel.deleteEmployee(EmployeePanel.this.employee);
                }
            });
            labelAndDeletePanel.add((Component)this.deleteButton, "East");
        }
        this.add((Component)labelAndDeletePanel, "West");
        this.resetShiftListPanel();
        this.numberOfShiftAssignmentsLabel = new JLabel("0 assignments", 4);
        this.numberOfShiftAssignmentsLabel.setPreferredSize(new Dimension(130, 20));
        this.numberOfShiftAssignmentsLabel.setEnabled(false);
        this.add((Component)this.numberOfShiftAssignmentsLabel, "East");
    }

    public void resetShiftListPanel() {
        JPanel shiftDatePanel;
        if (this.shiftDateListPanel != null) {
            this.remove(this.shiftDateListPanel);
        }
        WeekendDefinition weekendDefinition = this.employee == null ? WeekendDefinition.SATURDAY_SUNDAY : this.employee.getContract().getWeekendDefinition();
        this.shiftDateListPanel = new JPanel(new GridLayout(1, 0));
        this.shiftDatePanelMap = new LinkedHashMap<ShiftDate, JPanel>(this.shiftDateList.size());
        for (ShiftDate shiftDate : this.shiftDateList) {
            shiftDatePanel = new JPanel(new GridLayout(1, 0));
            if (weekendDefinition.isWeekend(shiftDate.getDayOfWeek())) {
                shiftDatePanel.setBackground(TangoColors.ALUMINIUM_2);
            }
            shiftDatePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColors.ALUMINIUM_6), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            this.shiftDatePanelMap.put(shiftDate, shiftDatePanel);
            if (this.employee == null) {
                JPanel wrappingShiftDatePanel = new JPanel(new BorderLayout());
                JLabel shiftDateLabel = new JLabel(shiftDate.getLabel(), 0);
                wrappingShiftDatePanel.add((Component)shiftDateLabel, "North");
                wrappingShiftDatePanel.add((Component)shiftDatePanel, "Center");
                this.shiftDateListPanel.add(wrappingShiftDatePanel);
                continue;
            }
            this.shiftDateListPanel.add(shiftDatePanel);
        }
        this.shiftPanelMap = new LinkedHashMap<Shift, JPanel>(this.shiftList.size());
        for (Shift shift : this.shiftList) {
            shiftDatePanel = this.shiftDatePanelMap.get(shift.getShiftDate());
            JPanel shiftPanel = new JPanel();
            shiftPanel.setLayout(new BoxLayout(shiftPanel, 1));
            shiftPanel.setBackground(shiftDatePanel.getBackground());
            shiftPanel.setToolTipText((this.employee == null ? "Unassigned" : this.employee.getLabel()) + " on " + shift.getLabel());
            this.shiftPanelMap.put(shift, shiftPanel);
            shiftDatePanel.add(shiftPanel);
        }
        this.add((Component)this.shiftDateListPanel, "Center");
    }

    public void addShiftAssignment(ShiftAssignment shiftAssignment) {
        Shift shift = shiftAssignment.getShift();
        JPanel shiftPanel = this.shiftPanelMap.get(shift);
        JButton shiftAssignmentButton = new JButton(new ShiftAssignmentAction(shiftAssignment));
        shiftAssignmentButton.setMargin(new Insets(0, 0, 0, 0));
        int colorIndex = shift.getShiftType().getIndex() % TangoColors.SEQUENCE_1.length;
        shiftAssignmentButton.setBackground(TangoColors.SEQUENCE_1[colorIndex]);
        shiftAssignmentButton.setToolTipText((this.employee == null ? "Unassigned" : this.employee.getLabel()) + " on " + shift.getLabel());
        shiftPanel.add(shiftAssignmentButton);
        shiftPanel.repaint();
        this.shiftAssignmentButtonMap.put(shiftAssignment, shiftAssignmentButton);
    }

    public void removeShiftAssignment(ShiftAssignment shiftAssignment) {
        JPanel shiftPanel = this.shiftPanelMap.get(shiftAssignment.getShift());
        JButton shiftAssignmentButton = this.shiftAssignmentButtonMap.remove(shiftAssignment);
        shiftPanel.remove(shiftAssignmentButton);
        shiftPanel.repaint();
    }

    public void clearShiftAssignments() {
        for (JPanel shiftPanel : this.shiftPanelMap.values()) {
            shiftPanel.removeAll();
        }
        this.shiftAssignmentButtonMap.clear();
    }

    public void update() {
        this.numberOfShiftAssignmentsLabel.setText(this.shiftAssignmentButtonMap.size() + " assignments");
    }

    private class ShiftAssignmentAction
    extends AbstractAction {
        private ShiftAssignment shiftAssignment;

        public ShiftAssignmentAction(ShiftAssignment shiftAssignment) {
            super(shiftAssignment.getShift().getShiftType().getCode());
            this.shiftAssignment = shiftAssignment;
        }

        public void actionPerformed(ActionEvent e) {
            List<Employee> employeeList = EmployeePanel.this.nurseRosteringPanel.getNurseRoster().getEmployeeList();
            JComboBox<Object> employeeListField = new JComboBox<Object>(employeeList.toArray());
            employeeListField.setSelectedItem(this.shiftAssignment.getEmployee());
            int result = JOptionPane.showConfirmDialog(EmployeePanel.this.getRootPane(), employeeListField, "Select employee", 2);
            if (result == 0) {
                Employee toEmployee = (Employee)employeeListField.getSelectedItem();
                EmployeePanel.this.nurseRosteringPanel.moveShiftAssignmentToEmployee(this.shiftAssignment, toEmployee);
            }
        }
    }
}

