/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.planner.examples.common.swingui;

import java.awt.Color;

public class TangoColors {

    public static final Color CHAMELEON_1 = new Color(138, 226, 52);
    public static final Color CHAMELEON_2 = new Color(115, 210, 22);
    public static final Color CHAMELEON_3 = new Color(78, 154, 6);
    public static final Color BUTTER_1 = new Color(252, 233, 79);
    public static final Color BUTTER_2 = new Color(237, 212, 0);
    public static final Color BUTTER_3 = new Color(196, 160, 0);
    public static final Color SKY_BLUE_1 = new Color(114, 159, 207);
    public static final Color SKY_BLUE_2 = new Color(52, 101, 164);
    public static final Color SKY_BLUE_3 = new Color(32, 74, 135);
    public static final Color CHOCOLATE_1 = new Color(233, 185, 110);
    public static final Color CHOCOLATE_2 = new Color(193, 125, 17);
    public static final Color CHOCOLATE_3 = new Color(143, 89, 2);
    public static final Color PLUM_1 = new Color(173, 127, 168);
    public static final Color PLUM_2 = new Color(117, 80, 123);
    public static final Color PLUM_3 = new Color(92, 53, 102);

    public static final Color SCARLET_1 = new Color(239, 41, 41);
    public static final Color SCARLET_2 = new Color(204, 0, 0);
    public static final Color SCARLET_3 = new Color(164, 0, 0);
    public static final Color ORANGE_1 = new Color(252, 175, 62);
    public static final Color ORANGE_2 = new Color(245, 121, 0);
    public static final Color ORANGE_3 = new Color(206, 92, 0);

    public static final Color ALUMINIUM_1 = new Color(238, 238, 236);
    public static final Color ALUMINIUM_2 = new Color(211, 215, 207);
    public static final Color ALUMINIUM_3 = new Color(186, 189, 182);
    public static final Color ALUMINIUM_4 = new Color(136, 138, 133);
    public static final Color ALUMINIUM_5 = new Color(85, 87, 83);
    public static final Color ALUMINIUM_6 = new Color(46, 52, 54);

    // Scarlet and orange are reserved for hard and soft constraints
    public static final Color[] SEQUENCE_1 = {
            TangoColors.CHAMELEON_1, TangoColors.BUTTER_1, TangoColors.SKY_BLUE_1, TangoColors.CHOCOLATE_1,
            TangoColors.PLUM_1
    };
    public static final Color[] SEQUENCE_2 = {
            TangoColors.CHAMELEON_2, TangoColors.BUTTER_2, TangoColors.SKY_BLUE_2, TangoColors.CHOCOLATE_2,
            TangoColors.PLUM_2
    };
    public static final Color[] SEQUENCE_3 = {
            TangoColors.CHAMELEON_3, TangoColors.BUTTER_3, TangoColors.SKY_BLUE_3, TangoColors.CHOCOLATE_3,
            TangoColors.PLUM_3
    };

}
