/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.travelingtournament.solver.smart.move;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.travelingtournament.domain.Day;
import org.drools.planner.examples.travelingtournament.domain.Match;
import org.drools.planner.examples.travelingtournament.solver.move.TravelingTournamentMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchSwapMove
implements Move {
    private Match leftMatch;
    private Match rightMatch;

    public MatchSwapMove(Match leftMatch, Match rightMatch) {
        this.leftMatch = leftMatch;
        this.rightMatch = rightMatch;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return true;
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return this;
    }

    public void doMove(ScoreDirector scoreDirector) {
        Day oldLeftDay = this.leftMatch.getDay();
        Day oldRightDay = this.rightMatch.getDay();
        TravelingTournamentMoveHelper.moveDay(scoreDirector, this.leftMatch, oldRightDay);
        TravelingTournamentMoveHelper.moveDay(scoreDirector, this.rightMatch, oldLeftDay);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftMatch, this.rightMatch);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Arrays.asList(this.leftMatch.getDay(), this.rightMatch.getDay());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MatchSwapMove) {
            MatchSwapMove other = (MatchSwapMove)o;
            return new EqualsBuilder().append((Object)this.leftMatch, (Object)other.leftMatch).append((Object)this.rightMatch, (Object)other.rightMatch).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.leftMatch).append((Object)this.rightMatch).toHashCode();
    }

    public String toString() {
        return this.leftMatch + " <=> " + this.rightMatch;
    }
}

