/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.tsp.swingui;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.examples.common.domain.AbstractPersistable;
import org.drools.planner.examples.tsp.domain.Appearance;
import org.drools.planner.examples.tsp.domain.Domicile;
import org.drools.planner.examples.tsp.domain.TravelingSalesmanTour;
import org.drools.planner.examples.tsp.domain.Visit;
import org.drools.planner.examples.tsp.swingui.TspPanel;

public class TspListPanel
extends JPanel {
    private static final Color HEADER_COLOR = Color.YELLOW;
    private final TspPanel tspPanel;

    public TspListPanel(TspPanel tspPanel) {
        this.tspPanel = tspPanel;
        this.setLayout(new GridLayout(0, 1));
    }

    public void resetPanel(TravelingSalesmanTour travelingSalesmanTour) {
        this.removeAll();
        JLabel headerLabel = new JLabel("Tour of " + travelingSalesmanTour.getName());
        headerLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        headerLabel.setBackground(HEADER_COLOR);
        headerLabel.setOpaque(true);
        this.add(headerLabel);
        for (Domicile domicile : travelingSalesmanTour.getDomicileList()) {
            JLabel domicileLabel = new JLabel(domicile.getCity().getSafeName());
            this.add(domicileLabel);
        }
        for (Visit visit : travelingSalesmanTour.getVisitList()) {
            JPanel visitPanel = new JPanel(new GridLayout(1, 2));
            JButton button = new JButton(new VisitAction(visit));
            visitPanel.add(button);
            String distanceLabelString = visit.getPreviousAppearance() == null ? "Unassigned" : "After " + visit.getPreviousAppearance().getCity().getSafeName() + " with distance " + visit.getDistanceToPreviousAppearance();
            visitPanel.add(new JLabel(distanceLabelString));
            this.add(visitPanel);
        }
    }

    public void updatePanel(TravelingSalesmanTour travelingSalesmanTour) {
        this.resetPanel(travelingSalesmanTour);
    }

    private class VisitAction
    extends AbstractAction {
        private Visit visit;

        public VisitAction(Visit visit) {
            super(visit.getCity().getSafeName());
            this.visit = visit;
        }

        public void actionPerformed(ActionEvent e) {
            TravelingSalesmanTour travelingSalesmanTour = TspListPanel.this.tspPanel.getTravelingSalesmanTour();
            JComboBox<AbstractPersistable> previousAppearanceListField = new JComboBox<AbstractPersistable>();
            for (Visit visit : travelingSalesmanTour.getVisitList()) {
                previousAppearanceListField.addItem(visit);
            }
            for (Domicile domicile : travelingSalesmanTour.getDomicileList()) {
                previousAppearanceListField.addItem(domicile);
            }
            previousAppearanceListField.setSelectedItem(this.visit.getPreviousAppearance());
            int result = JOptionPane.showConfirmDialog(TspListPanel.this.getRootPane(), previousAppearanceListField, "Visit " + this.visit.getCity().getSafeName() + " after", 2);
            if (result == 0) {
                Appearance appearance = (Appearance)previousAppearanceListField.getSelectedItem();
                JOptionPane.showMessageDialog(TspListPanel.this, "Unsupported operation.");
                TspListPanel.this.tspPanel.getWorkflowFrame().resetScreen();
            }
        }
    }
}

