/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.nqueens.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.common.swingui.TangoColors;
import org.drools.planner.examples.nqueens.domain.NQueens;
import org.drools.planner.examples.nqueens.domain.Queen;
import org.drools.planner.examples.nqueens.domain.Row;
import org.drools.planner.examples.nqueens.solver.move.RowChangeMove;

public class NQueensPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/drools/planner/examples/nqueens/swingui/nqueensLogo.png";
    private static final String QUEEN_IMAGE_PATH = "/org/drools/planner/examples/nqueens/swingui/queenImage.png";
    private ImageIcon queenImageIcon;

    public NQueensPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.BLACK);
        this.queenImageIcon = new ImageIcon(this.getClass().getResource(QUEEN_IMAGE_PATH));
    }

    private NQueens getNQueens() {
        return (NQueens)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        this.removeAll();
        this.repaint();
        NQueens nQueens = (NQueens)solution;
        int n = nQueens.getN();
        List<Queen> queenList = nQueens.getQueenList();
        this.setLayout(new GridLayout(n, n));
        for (int row = 0; row < n; ++row) {
            for (int column = 0; column < n; ++column) {
                Queen queen = queenList.get(column);
                if (queen.getColumn().getIndex() != column) {
                    throw new IllegalStateException("The queenList is not in the expected order.");
                }
                String toolTipText = "row " + row + ", column " + column;
                if (queen.getRow() != null && queen.getRow().getIndex() == row) {
                    JButton button = new JButton(new QueenAction(queen));
                    button.setMinimumSize(new Dimension(20, 20));
                    button.setPreferredSize(new Dimension(20, 20));
                    button.setToolTipText(toolTipText);
                    this.add(button);
                    continue;
                }
                JPanel panel = new JPanel();
                panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(TangoColors.ALUMINIUM_6), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                Color background = (row + column) % 2 == 0 ? Color.WHITE : TangoColors.ALUMINIUM_3;
                panel.setBackground(background);
                panel.setToolTipText(toolTipText);
                this.add(panel);
            }
        }
    }

    private class QueenAction
    extends AbstractAction {
        private Queen queen;

        public QueenAction(Queen queen) {
            super(null, NQueensPanel.this.queenImageIcon);
            this.queen = queen;
        }

        public void actionPerformed(ActionEvent e) {
            List<Row> rowList = NQueensPanel.this.getNQueens().getRowList();
            JPanel messagePanel = new JPanel(new BorderLayout());
            messagePanel.add((Component)new JLabel("Move to row: "), "West");
            JComboBox<Object> rowListField = new JComboBox<Object>(rowList.toArray());
            rowListField.setSelectedItem(this.queen.getRow());
            messagePanel.add(rowListField, "Center");
            int result = JOptionPane.showConfirmDialog(NQueensPanel.this.getRootPane(), messagePanel, "Queen in column " + this.queen.getColumn().getIndex(), 2);
            if (result == 0) {
                Row toRow = (Row)rowListField.getSelectedItem();
                RowChangeMove move = new RowChangeMove(this.queen, toRow);
                NQueensPanel.this.solutionBusiness.doMove(move);
                NQueensPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

