/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.solver.move.CloudBalancingMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudComputerChangeMove
implements Move {
    private CloudProcess cloudProcess;
    private CloudComputer toCloudComputer;

    public CloudComputerChangeMove(CloudProcess cloudProcess, CloudComputer toCloudComputer) {
        this.cloudProcess = cloudProcess;
        this.toCloudComputer = toCloudComputer;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.cloudProcess.getComputer(), (Object)this.toCloudComputer);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new CloudComputerChangeMove(this.cloudProcess, this.cloudProcess.getComputer());
    }

    public void doMove(ScoreDirector scoreDirector) {
        CloudBalancingMoveHelper.moveCloudComputer(scoreDirector, this.cloudProcess, this.toCloudComputer);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.cloudProcess);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toCloudComputer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CloudComputerChangeMove) {
            CloudComputerChangeMove other = (CloudComputerChangeMove)o;
            return new EqualsBuilder().append((Object)this.cloudProcess, (Object)other.cloudProcess).append((Object)this.toCloudComputer, (Object)other.toCloudComputer).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.cloudProcess).append((Object)this.toCloudComputer).toHashCode();
    }

    public String toString() {
        return this.cloudProcess + " => " + this.toCloudComputer;
    }
}

