/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.curriculumcourse.solver.move;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.examples.curriculumcourse.domain.Lecture;
import org.drools.planner.examples.curriculumcourse.domain.Period;
import org.drools.planner.examples.curriculumcourse.solver.move.CurriculumCourseMoveHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeriodChangeMove
implements Move {
    private Lecture lecture;
    private Period toPeriod;

    public PeriodChangeMove(Lecture lecture, Period toPeriod) {
        this.lecture = lecture;
        this.toPeriod = toPeriod;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return !ObjectUtils.equals((Object)this.lecture.getPeriod(), (Object)this.toPeriod);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new PeriodChangeMove(this.lecture, this.lecture.getPeriod());
    }

    public void doMove(ScoreDirector scoreDirector) {
        CurriculumCourseMoveHelper.movePeriod(scoreDirector, this.lecture, this.toPeriod);
    }

    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.lecture);
    }

    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PeriodChangeMove) {
            PeriodChangeMove other = (PeriodChangeMove)o;
            return new EqualsBuilder().append((Object)this.lecture, (Object)other.lecture).append((Object)this.toPeriod, (Object)other.toPeriod).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.lecture).append((Object)this.toPeriod).toHashCode();
    }

    public String toString() {
        return this.lecture + " => " + this.toPeriod;
    }
}

