/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.examination.persistence;

import java.io.IOException;
import java.util.Collections;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.common.domain.PersistableIdComparator;
import org.drools.planner.examples.common.persistence.AbstractTxtSolutionExporter;
import org.drools.planner.examples.examination.domain.Exam;
import org.drools.planner.examples.examination.domain.Examination;
import org.drools.planner.examples.examination.persistence.ExaminationDaoImpl;

public class ExaminationSolutionExporter
extends AbstractTxtSolutionExporter {
    private static final String OUTPUT_FILE_SUFFIX = ".sln";

    public static void main(String[] args) {
        new ExaminationSolutionExporter().convertAll();
    }

    public ExaminationSolutionExporter() {
        super(new ExaminationDaoImpl());
    }

    protected String getOutputFileSuffix() {
        return OUTPUT_FILE_SUFFIX;
    }

    public AbstractTxtSolutionExporter.TxtOutputBuilder createTxtOutputBuilder() {
        return new ExaminationOutputBuilder();
    }

    public class ExaminationOutputBuilder
    extends AbstractTxtSolutionExporter.TxtOutputBuilder {
        private Examination examination;

        public ExaminationOutputBuilder() {
            super(ExaminationSolutionExporter.this);
        }

        public void setSolution(Solution solution) {
            this.examination = (Examination)solution;
        }

        public void writeSolution() throws IOException {
            Collections.sort(this.examination.getExamList(), new PersistableIdComparator());
            for (Exam exam : this.examination.getExamList()) {
                this.bufferedWriter.write(exam.getPeriod().getId() + ", " + exam.getRoom().getId() + "\r\n");
            }
        }
    }
}

